'''OpenGL extension EXT.fog_coord

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.fog_coord to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension allows specifying an explicit per-vertex fog
	coordinate to be used in fog computations, rather than using a
	fragment depth-based fog equation.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/fog_coord.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.EXT.fog_coord import *
from OpenGL.raw.GL.EXT.fog_coord import _EXTENSION_NAME

def glInitFogCoordEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION