# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
ORACLE_RELEASES ?=
GARDEN_SYSTEMS += $(foreach r,$(ORACLE_RELEASES),$(foreach a,x86_64 aarch64,oracle-cloud-$r.$a))

$(foreach R,$(ORACLE_RELEASES),oracle-cloud-$R.x86_64.run): oracle-cloud-%.x86_64.run: $(MAKEFILE_LIST) | oracle-cloud-%.x86_64.qcow2
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/oracle" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_X86_64_BIOS_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

$(foreach R,$(ORACLE_RELEASES),oracle-cloud-$R.aarch64.run): oracle-cloud-%.aarch64.run: $(MAKEFILE_LIST) | oracle-cloud-%.aarch64.qcow2 oracle-cloud-%.aarch64.efi-code.img oracle-cloud-%.aarch64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/oracle" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

$(foreach R,$(ORACLE_RELEASES),oracle-cloud-$R.x86_64.qcow2): oracle-cloud-%.x86_64.qcow2: $(GARDEN_DL_DIR)/oracle/oracle-cloud-%.x86_64.qcow2 oracle-cloud-%.seed.iso
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_X86_64_BIOS_CMDLINE,$@) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

$(foreach R,$(ORACLE_RELEASES),oracle-cloud-$R.aarch64.qcow2): oracle-cloud-%.aarch64.qcow2: $(GARDEN_DL_DIR)/oracle/oracle-cloud-%.aarch64.qcow2 oracle-cloud-%.seed.iso oracle-cloud-%.aarch64.efi-code.img oracle-cloud-%.aarch64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

$(GARDEN_DL_DIR)/oracle: | $(GARDEN_DL_DIR)
	mkdir -p $@

oracle-cloud-%.meta-data: export META_DATA = $(call CLOUD_INIT_META_DATA_TEMPLATE,oracle-$*)
oracle-cloud-%.meta-data: $(MAKEFILE_LIST)
	echo "$${META_DATA}" | tee $@

oracle-cloud-%.user-data: export USER_DATA = $(call $(call PICK_CLOUD_INIT_USER_DATA_TEMPLATE_FOR,ORACLE,$*),oracle-$*,oracle)
oracle-cloud-%.user-data: $(MAKEFILE_LIST) $(wildcard .image-garden.mk)
	echo "$${USER_DATA}" | tee $@

.PHONY: clean
clean::
	rm -f $(foreach R,$(ORACLE_RELEASES),$(foreach A,x86_64 aarch64,oracle-cloud-$R.$A.qcow2 oracle-cloud-$R.$A.run))
