// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.jetbrains.jsonSchema;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class JsonPointerResolver {
  private final JsonValue myRoot;
  private final String myPointer;

  public JsonPointerResolver(@NotNull JsonValue root, @NotNull String pointer) {
    myRoot = root;
    myPointer = pointer;
  }

  @Nullable
  public JsonValue resolve() {
    JsonValue root = myRoot;
    final List<JsonSchemaVariantsTreeBuilder.Step> steps = JsonSchemaVariantsTreeBuilder.buildSteps(myPointer);
    for (JsonSchemaVariantsTreeBuilder.Step step : steps) {
      String name = step.getName();
      if (name != null) {
        if (!(root instanceof JsonObject)) return null;
        JsonProperty property = ((JsonObject)root).findProperty(name);
        root = property == null ? null : property.getValue();
      }
      else {
        int idx = step.getIdx();
        if (idx < 0) return null;

        if (!(root instanceof JsonArray)) {
          if (root instanceof JsonObject) {
            JsonProperty property = ((JsonObject)root).findProperty(String.valueOf(idx));
            if (property == null) {
              return null;
            }
            root = property.getValue();
            continue;
          }
          else {
            return null;
          }
        }
        List<JsonValue> list = ((JsonArray)root).getValueList();
        if (idx >= list.size()) return null;
        root = list.get(idx);
      }
    }
    return root;
  }


}
