/*
 * Decompiled with CFR 0.152.
 */
package org.freshcookies.security.cert;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.freshcookies.security.cert.Trustee;

public class SSLHelper {
    protected static final int SSL_PORT = 443;

    public static Certificate[] extractSSLCertificates(String hostname, int port) {
        Certificate[] certs = new Certificate[]{};
        X509TrustManager trustManager = SSLHelper.nullTrustManager();
        SSLSocket socket = SSLHelper.createSSLSocket(new TrustManager[]{trustManager}, hostname, port);
        if (socket != null) {
            try {
                certs = socket.getSession().getPeerCertificates();
                socket.close();
            }
            catch (SSLPeerUnverifiedException e) {
                System.out.println("Could not verify peer: " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("Could not close socket: " + e.getMessage());
            }
        } else {
            System.err.println("could not create SSL socket.");
        }
        return certs;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("FATAL: you must supply a host name (e.g., internal.atstake.com)");
            System.exit(1);
        }
        if (args[0].equals("--help") | args[0].equals("-h")) {
            System.out.println("Usage: SSLHelper hostname [port]");
            System.exit(0);
        }
        String host = args[0];
        int port = 443;
        if (args.length > 1) {
            port = Integer.parseInt(args[1]);
        }
        System.out.print("Extracting SSL certificates from " + host + ":" + port + "... ");
        Certificate[] certs = SSLHelper.extractSSLCertificates(host, port);
        if (certs.length == 0) {
            System.err.println("ERROR: No certificates found. Is there an SSL server running on this host?\n");
            System.exit(1);
        }
        System.out.println(String.valueOf(certs.length) + " certificate" + (certs.length == 1 ? "" : "s") + " found.");
        boolean certsAdded = false;
        Trustee trustee = new Trustee();
        int i = 0;
        while (i < certs.length) {
            if (certs[i] instanceof X509Certificate) {
                X509Certificate cert = (X509Certificate)certs[i];
                System.out.println("Certificate[" + i + "]:");
                System.out.println(Trustee.getCertificateInfo(cert));
                try {
                    trustee.saveCertificate(cert);
                }
                catch (Exception e) {
                    System.err.println("ERROR: could not save certificate. " + e.getMessage());
                }
                if (i == 0) {
                    System.out.println("This is the server certificate.");
                } else {
                    try {
                        certsAdded |= trustee.trustCACertificate(cert);
                    }
                    catch (KeyStoreException e) {
                        System.out.println(e.getLocalizedMessage());
                    }
                }
                System.out.println("");
            }
            ++i;
        }
        if (certs.length == 1) {
            System.err.println("WARNING: certificate chain did not include issuing CA certificate. How rude!\n");
        }
        if (certsAdded) {
            trustee.commit();
        }
    }

    private static SSLSocket createSSLSocket(TrustManager[] trustManager, String hostname, int port) {
        SSLSocket socket = null;
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustManager, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            SSLSocketFactory factory = sslContext.getSocketFactory();
            socket = (SSLSocket)factory.createSocket(hostname, port);
            socket.startHandshake();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return socket;
    }

    private static X509TrustManager nullTrustManager() {
        return new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
    }
}

