// Copyright 2014 Canonical Ltd.
// Licensed under the AGPLv3, see LICENCE file for details.

package environs

import (
	"launchpad.net/juju-core/environs/config"
	"launchpad.net/juju-core/errors"
	"launchpad.net/juju-core/state"
)

// environStatePolicy implements state.Policy in
// terms of environs.Environ and related types.
type environStatePolicy struct{}

var _ state.Policy = environStatePolicy{}

// NewStatePolicy returns a state.Policy that is
// implemented in terms of Environ and related
// types.
func NewStatePolicy() state.Policy {
	return environStatePolicy{}
}

func (environStatePolicy) Prechecker(cfg *config.Config) (state.Prechecker, error) {
	env, err := New(cfg)
	if err != nil {
		return nil, err
	}

	if p, ok := env.(state.Prechecker); ok {
		return p, nil
	}
	return nil, errors.NewNotImplementedError("Prechecker")
}

func (environStatePolicy) ConfigValidator(providerType string) (state.ConfigValidator, error) {
	return Provider(providerType)
}
