/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "widgetoptions.h"

//pour les variables statiques des classes calcul et WidgetHorloge
#include "calcul.h"
#include "widgethorloge.h"
#include "tirage.h"
#include "widgetoperation.h"
#include "global.h"

#include <QtGui>
#include <fstream>

//cration et initialisation des variables statiques
int WidgetOptions::min_temps_reflexion=10;
int WidgetOptions::max_temps_reflexion=300;
int WidgetOptions::min_nb_plaques=3;
int WidgetOptions::max_nb_plaques=6;
int WidgetOptions::min_min_compte=1;
int WidgetOptions::max_min_compte=100;
int WidgetOptions::min_max_compte=1;
int WidgetOptions::max_max_compte=999;

int WidgetOptions::NVE_LANGUE=5;  //valeur pour relancer l'appli (valeur sans importance - sauf 0)

//en dbut de programme, la variable langue contient la langue locale du systme
QString WidgetOptions::langue=QLocale::system().name();

bool WidgetOptions::sauveOptions=false;

//constructeur de la fentre d'options
WidgetOptions::WidgetOptions(QWidget* parent) : QDialog( parent) {
	//titre de la fentre
	setWindowTitle(QString(tr("Options")));
	
	QGroupBox *simplif = new QGroupBox(tr("Simplifications"), this);
	//boutons  cocher pour les diverses canonisations
	QLabel *titrecano1 = new QLabel(simplif);
	titrecano1->setText(tr("Activer \"2+2=22\""));
	titrecano1->setToolTip(tr("Exploite la proprit \"2+2=22\" pour diminuer le nombre de solutions"));
	cano1 = new QCheckBox(simplif);
	
	QLabel *titrecano2 = new QLabel(simplif);
	titrecano2->setText(tr("Activer \"sous-calcul\""));
	titrecano2->setToolTip(tr("N'affiche pas les solutions dont un sous-calcul est lui-mme une solution"));
	cano2 = new QCheckBox(simplif);
	
	QLabel *titrecano3 = new QLabel(simplif);
	titrecano3->setText(tr("Activer \"factorisation\""));
	titrecano3->setToolTip(tr("Considre comme quivalentes les formes dveloppes et factorises d'un mme calcul"));
	cano3 = new QCheckBox(simplif);
	
	QGridLayout *simplifLayout= new QGridLayout( simplif );
	simplifLayout->addWidget(titrecano1, 0, 0);
	simplifLayout->addWidget(cano1, 0, 1, 1, 1, Qt::AlignRight);
	simplifLayout->addWidget(titrecano2, 1, 0);
	simplifLayout->addWidget(cano2, 1, 1, 1, 1, Qt::AlignRight);
	simplifLayout->addWidget(titrecano3, 2, 0);
	simplifLayout->addWidget(cano3, 2, 1, 1, 1, Qt::AlignRight);

	QGroupBox *regles = new QGroupBox(tr("Rgles du jeu"), this);
	//rglage du temps de rflexion
	QLabel *titreTemps = new QLabel(regles);
	titreTemps->setText(tr("Temps de rflexion"));
	boxTemps = new QSpinBox(regles);
	boxTemps->setRange(min_temps_reflexion,max_temps_reflexion);
	boxTemps->setFixedSize(boxTemps->sizeHint());
	
	//rglage du nombre de plaques
	QLabel *titreNbPlaque = new QLabel(regles);
	titreNbPlaque->setText(tr("Nombre de plaques"));
	boxNbPlaque = new QSpinBox(regles);
	boxNbPlaque->setRange(min_nb_plaques,max_nb_plaques);
	boxNbPlaque->setFixedSize(boxNbPlaque->sizeHint());
	
	//rglage de la valeur minimale du compte
	QLabel *titreCompte = new QLabel(regles);
	titreCompte->setText(tr("Valeur minimale du compte"));
	boxCompte = new QSpinBox(regles);
	boxCompte->setRange(min_min_compte,max_min_compte);
	boxCompte->setFixedSize(boxCompte->sizeHint());
	
	//rglage de la valeur maximale du compte
	QLabel *titreCompte2 = new QLabel(regles);
	titreCompte2->setText(tr("Valeur maximale du compte"));
	boxCompte2 = new QSpinBox(regles);
	boxCompte2->setRange(min_max_compte,max_max_compte);
	boxCompte2->setFixedSize(boxCompte2->sizeHint());
	
	QGridLayout *reglesLayout= new QGridLayout( regles );
	reglesLayout->addWidget(titreTemps, 0, 0);
	reglesLayout->addWidget(boxTemps, 0, 1);
	reglesLayout->addWidget(titreNbPlaque, 1, 0);
	reglesLayout->addWidget(boxNbPlaque, 1, 1, 1, 1, Qt::AlignRight);
	reglesLayout->addWidget(titreCompte, 2, 0);
	reglesLayout->addWidget(boxCompte, 2, 1);
	reglesLayout->addWidget(titreCompte2, 3, 0);
	reglesLayout->addWidget(boxCompte2, 3, 1);
	
	QGroupBox *grouplangue = new QGroupBox(tr("Localisation"), this);
	//boutons  cocher pour les diverses localisations
	QLabel *titrelangue1 = new QLabel(grouplangue);
	titrelangue1->setText("Franais");
	langue1 = new QRadioButton(grouplangue);
	
	QLabel *titrelangue2 = new QLabel(grouplangue);
	titrelangue2->setText("English");
	langue2 = new QRadioButton(grouplangue);
	
	QLabel *titrelangue3 = new QLabel(grouplangue);
	//valeur unicode des caractre du terme "japonais" en japonais, entre 0 et 65535.
	//hack foireux pour que ce fichier source ne soit pas en unicode.
	ushort carac1=26085;
	ushort carac2=26412;
	ushort carac3=35486;
	QString japonais;
	japonais.append(carac1);
	japonais.append(carac2);
	japonais.append(carac3);
	titrelangue3->setText(japonais);
	langue3 = new QRadioButton(grouplangue);
	
	QGridLayout *langueLayout= new QGridLayout;
	langueLayout->addWidget(titrelangue1, 0, 0);
	langueLayout->addWidget(langue1, 0, 2, 1, 1, Qt::AlignRight);
	langueLayout->addWidget(titrelangue2, 1, 0);
	langueLayout->addWidget(langue2, 1, 2, 1, 1, Qt::AlignRight);
	langueLayout->addWidget(titrelangue3, 2, 0);
	langueLayout->addWidget(langue3, 2, 2, 1, 1, Qt::AlignRight);
	grouplangue->setLayout(langueLayout);
	
	//checkbox de sauvegarde des options
	QWidget *sauveHbox = new QWidget( this );
	QHBoxLayout *hlayout1 = new QHBoxLayout( sauveHbox );
	sauveOptionsBox = new QCheckBox( sauveHbox );
	QLabel *sauveOptionsTitre = new QLabel( sauveHbox );
	sauveOptionsTitre->setText( tr("Sauvegarder les options") );
	hlayout1->addWidget( sauveOptionsTitre );
	hlayout1->addStretch(1);
	hlayout1->addWidget( sauveOptionsBox );
	hlayout1->setSpacing(1);
	hlayout1->setMargin(1);
	
	QWidget *boutonsHbox = new QWidget( this );
	QHBoxLayout *hlayout2 = new QHBoxLayout( boutonsHbox );
	
	//bouton pour rtablir les options par dfaut
	QPushButton *pbDefaut = new QPushButton( tr("Options par dfaut"), boutonsHbox );
	pbDefaut->setFont( font_normal );
	connect( pbDefaut, SIGNAL( clicked() ), this, SLOT( modifDefaut() ) );
	
	//bouton "OK" pour fermer la fentre
	QPushButton *pbOk = new QPushButton( tr("OK"), boutonsHbox );
	pbOk->setFont( font_normal );
	pbOk->setFocus();	//Le bouton "OK" a le focus au lancement de la fentre
	connect( pbOk, SIGNAL( clicked() ), this, SLOT( modifOk() ) );
	
	hlayout2->addWidget( pbDefaut );
	hlayout2->addStretch(1);
	hlayout2->addWidget( pbOk );
	hlayout2->setSpacing(1);
	hlayout2->setMargin(1);
	
	//positionnement des widgets
	QVBoxLayout *vlayout = new QVBoxLayout( this );
	
	vlayout->addWidget(simplif);
	vlayout->addWidget(regles);
	vlayout->addWidget(grouplangue);
	vlayout->addWidget(sauveHbox);
	vlayout->addWidget(boutonsHbox);
	
	//initialisation des etats
	if (calcul::cano1_actif) {
		cano1->setCheckState(Qt::Checked);
	} else {
		cano1->setCheckState(Qt::Unchecked);
	}
	
	if (calcul::cano2_actif) {
		cano2->setCheckState(Qt::Checked);
	} else {
		cano2->setCheckState(Qt::Unchecked);
	}
	
	if (calcul::cano3_actif) {
		cano3->setCheckState(Qt::Checked);
	} else {
		cano3->setCheckState(Qt::Unchecked);
	}
	
	if (langue=="fr") {
		langue1->setDown(true);
	}
	if (langue=="en") {
		langue2->setDown(true);
	}
	if (langue=="ja") {
		langue3->setDown(true);
	}
	
	boxTemps->setValue(WidgetHorloge::nb_sec);
	boxNbPlaque->setValue(tirage::nb_plaques);
	boxCompte->setValue(tirage::compte_minimal);
	boxCompte2->setValue(tirage::compte_maximal);
	
	if(sauveOptions) {
		sauveOptionsBox->setCheckState(Qt::Checked);
	} else {
		sauveOptionsBox->setCheckState(Qt::Unchecked);
	}
}

//les modifs sont valides
void WidgetOptions::modifOk() {
	//modification des paramtres
	calcul::cano1_actif=cano1->isChecked();
	calcul::cano2_actif=cano2->isChecked();
	calcul::cano3_actif=cano3->isChecked();
	WidgetHorloge::nb_sec=boxTemps->value();
	
	bool changementNbPlaque =false;
	if(tirage::nb_plaques != boxNbPlaque->value()) {
		tirage::nb_plaques=boxNbPlaque->value();
		changementNbPlaque = true;
	}
	
	if(boxCompte->value()<boxCompte2->value()){		//cas normal o la valeur rentre pour le compte minimal est plus petite que l'autre
		tirage::compte_minimal=boxCompte->value();
		tirage::compte_maximal=boxCompte2->value();
	}
	else{							//cas o l'utilisateur est un boulet
		tirage::compte_minimal=boxCompte2->value();
		tirage::compte_maximal=boxCompte->value();
	}
	
	//rglage paramtre de langue
	if(langue1->isChecked() || langue2->isChecked() || langue3->isChecked()) {
		//utilisation de la traduction demande
		//on a besoin de quitter l'appli - elle est relance automatiquement dans la boucle principale
		if(langue1->isChecked()) {
			langue="fr";
		} else if (langue2->isChecked()) {
			langue="en";
		} else if (langue3->isChecked()) {
			langue="ja";
		}
	}
	
	//sauvegarde ou non des options sur le disque
	sauveOptions=sauveOptionsBox->isChecked();
	
	QString entete=QString("[Kitsune").append(global::numero_version).append(QString("]"));
	QString cheminFichierOptions=QString("/.kitsune.options.").append(global::numero_version);
	
	if(sauveOptions) {
		//criture du fichier de sauvegarde des options
		string filename=(QDir::homePath()+cheminFichierOptions).toStdString();
		ofstream f_options(filename.c_str()); //TODO : utiliser un objet QFile au lieu de ofstream
		if (f_options.is_open()){
			f_options << entete.toStdString() << endl;
			f_options << calcul::cano1_actif << endl;
			f_options << calcul::cano2_actif << endl;
			f_options << calcul::cano3_actif << endl;
			f_options << WidgetHorloge::nb_sec << endl;
			f_options << tirage::nb_plaques << endl;
			f_options << tirage::compte_minimal << endl;
			f_options << tirage::compte_maximal << endl;
			if (langue!="") {
				f_options << langue.toStdString() << endl;
			} else {
				f_options << "default" << endl;
			}
			f_options.close();
		}
	} else {
		//suppresion du fichier d'options (si existant)
		supprFichierOptions();
	}
	
	//appli relance si ncessaire (changement de langue)
	//note : qApp est un nom rserv qui dsigne l'application Qt elle-mme
	if(langue1->isChecked() || langue2->isChecked() || langue3->isChecked() || changementNbPlaque) {
		qApp->exit(NVE_LANGUE);
	}
	
	//fermeture du widget des options
	close();
}

//Pour remettre les options  leur valeur par dfaut
void WidgetOptions::modifDefaut() {
	cano1->setCheckState(Qt::Checked);
	cano2->setCheckState(Qt::Checked);
	cano3->setCheckState(Qt::Checked);
	boxTemps->setValue(50);
	boxNbPlaque->setValue(6);
	boxCompte->setValue(100);
	boxCompte2->setValue(999);
}

//note : fonction appele dans kitsune.cpp avant de lancer le widget principal
void WidgetOptions::lireFichier() {
	QString cheminFichierOptions=QString("/.kitsune.options.").append(global::numero_version);
	QFile f_options(QDir::homePath()+cheminFichierOptions);
	
	//fin de la fonction si le fichier n'existe pas
	if (!f_options.exists()) return;
	
	//le fichier existe : la sauvegarde des options est donc active
	sauveOptions = true;
	
	f_options.open( QIODevice::ReadOnly );
	QTextStream ts( &f_options );
	
	//lecture de l'entte
	QString entete=QString("[Kitsune").append(global::numero_version).append(QString("]"));
	QString debut;
	ts >> debut;
	if(debut != entete) {
		//ce fichier ne correspond pas  cette version de kitsune; on l'ignore
		f_options.close();
		return;
	}
	
	//lecture des valeurs
	int valeur_1, valeur_2, valeur_3, valeur_4, valeur_5, valeur_6, valeur_7;	
	ts >> valeur_1; ts >> valeur_2; ts >> valeur_3; ts >> valeur_4; ts >> valeur_5; ts >> valeur_6; ts >> valeur_7;
	
	//test de la validit des valeurs
	if( valeur_1>=0 && valeur_1<=1 && valeur_2>=0 && valeur_2<=1 && valeur_3>=0 && valeur_3<=1
		&& valeur_4>=min_temps_reflexion && valeur_4<=max_temps_reflexion 
		&& valeur_5>=min_nb_plaques && valeur_5<=max_nb_plaques
		&& valeur_6>=min_min_compte && valeur_6<=max_min_compte 
		&& valeur_7>=min_max_compte && valeur_7<=max_max_compte
		&& valeur_6<=valeur_7) {
		calcul::cano1_actif=valeur_1;
		calcul::cano2_actif=valeur_2;
		calcul::cano3_actif=valeur_3;
		WidgetHorloge::nb_sec=valeur_4;
		tirage::nb_plaques=valeur_5;
		tirage::compte_minimal=valeur_6;
		tirage::compte_maximal=valeur_7;
	}
	else {
		QMessageBox::warning (0, tr("Options"), tr("Fichier d'options incorrect."), QMessageBox::Ok);
	}
	
	//lecture de la langue
	ts >> langue;
	if (langue=="default") {
		langue="";
	}
	
	f_options.close();
}

void WidgetOptions::supprFichierOptions() {
	QString cheminFichierOptions=QString("/.kitsune.options.").append(global::numero_version);
	QFile f_options(QDir::homePath()+cheminFichierOptions);
	
	//fin de la fonction si le fichier n'existe pas
	if (!f_options.exists()) {
		return;
	}
	
	if(f_options.remove()) {
		QMessageBox::information (this, tr("Suppression"), tr("Le fichier d'options a t supprim."), QMessageBox::Ok);
	
	} else {
		//TODO : indiquer le chemin du fichier d'options dans le message d'erreur
		QMessageBox::warning (this, tr("Suppression"), tr("La suppression du fichier d'options a chou."), QMessageBox::Ok);
	}
}
