with Ada.Text_IO; use Ada.Text_IO;

with GNAT.Strings;
with GNATCOLL.Projects; use GNATCOLL.Projects;

procedure test_it is
   GNAT_Version : GNAT.Strings.String_Access;
   Prj : Project_Environment_Access;
begin
   Initialize (Prj);
   Set_Path_From_Gnatls (Prj.all, "gnatls", GNAT_Version);

   --  Expected output example: "Pro 7.1.0w (20111129-45)"

   declare
      S : String renames GNAT_Version.all;
   begin
      if S'Length < 3
        or else S (S'First .. S'First + 2) /= "Pro"
        or else S (S'Last) /= ')'
      then
         Put_Line ("Test failed");
      end if;
   end;
end test_it;
