/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.HashMap;
import java.util.Map;
import org.htmlcleaner.HtmlCleanerException;

public class SpecialEntity {
    private static Map<String, SpecialEntity> entities = new HashMap<String, SpecialEntity>();
    private static int maxEntityLength = 0;
    private String key;
    private int intCode;

    public static void addEntity(String entityName, int intCode) throws HtmlCleanerException {
        if (entities.containsKey(entityName)) {
            throw new HtmlCleanerException("Entity \"" + entityName + "\" is already defined!");
        }
        entities.put(entityName, new SpecialEntity(entityName, intCode));
        int entityNameLen = entityName.length();
        if (entityNameLen > maxEntityLength) {
            maxEntityLength = entityNameLen;
        }
    }

    public static SpecialEntity getEntity(String key) {
        return entities.get(key);
    }

    static int getMaxEntityLength() {
        return maxEntityLength;
    }

    private SpecialEntity(String key, int intCode) {
        this.key = key;
        this.intCode = intCode;
    }

    public String getKey() {
        return this.key;
    }

    public int getIntCode() {
        return this.intCode;
    }

    public char getCharacter() {
        return (char)this.intCode;
    }

    public String getDecimalNCR() {
        return "&#" + this.intCode + ";";
    }

    public String getHexNCR() {
        return "&#x" + Integer.toHexString(this.intCode) + ";";
    }

    public String getEscapedValue() {
        return "&" + this.key + ";";
    }

    static {
        SpecialEntity.addEntity("nbsp", 160);
        SpecialEntity.addEntity("iexcl", 161);
        SpecialEntity.addEntity("cent", 162);
        SpecialEntity.addEntity("pound", 163);
        SpecialEntity.addEntity("curren", 164);
        SpecialEntity.addEntity("yen", 165);
        SpecialEntity.addEntity("brvbar", 166);
        SpecialEntity.addEntity("sect", 167);
        SpecialEntity.addEntity("uml", 168);
        SpecialEntity.addEntity("copy", 169);
        SpecialEntity.addEntity("ordf", 170);
        SpecialEntity.addEntity("laquo", 171);
        SpecialEntity.addEntity("not", 172);
        SpecialEntity.addEntity("shy", 173);
        SpecialEntity.addEntity("reg", 174);
        SpecialEntity.addEntity("macr", 175);
        SpecialEntity.addEntity("deg", 176);
        SpecialEntity.addEntity("plusmn", 177);
        SpecialEntity.addEntity("sup2", 178);
        SpecialEntity.addEntity("sup3", 179);
        SpecialEntity.addEntity("acute", 180);
        SpecialEntity.addEntity("micro", 181);
        SpecialEntity.addEntity("para", 182);
        SpecialEntity.addEntity("middot", 183);
        SpecialEntity.addEntity("cedil", 184);
        SpecialEntity.addEntity("sup1", 185);
        SpecialEntity.addEntity("ordm", 186);
        SpecialEntity.addEntity("raquo", 187);
        SpecialEntity.addEntity("frac14", 188);
        SpecialEntity.addEntity("frac12", 189);
        SpecialEntity.addEntity("frac34", 190);
        SpecialEntity.addEntity("iquest", 191);
        SpecialEntity.addEntity("Agrave", 192);
        SpecialEntity.addEntity("Aacute", 193);
        SpecialEntity.addEntity("Acirc", 194);
        SpecialEntity.addEntity("Atilde", 195);
        SpecialEntity.addEntity("Auml", 196);
        SpecialEntity.addEntity("Aring", 197);
        SpecialEntity.addEntity("AElig", 198);
        SpecialEntity.addEntity("Ccedil", 199);
        SpecialEntity.addEntity("Egrave", 200);
        SpecialEntity.addEntity("Eacute", 201);
        SpecialEntity.addEntity("Ecirc", 202);
        SpecialEntity.addEntity("Euml", 203);
        SpecialEntity.addEntity("Igrave", 204);
        SpecialEntity.addEntity("Iacute", 205);
        SpecialEntity.addEntity("Icirc", 206);
        SpecialEntity.addEntity("Iuml", 207);
        SpecialEntity.addEntity("ETH", 208);
        SpecialEntity.addEntity("Ntilde", 209);
        SpecialEntity.addEntity("Ograve", 210);
        SpecialEntity.addEntity("Oacute", 211);
        SpecialEntity.addEntity("Ocirc", 212);
        SpecialEntity.addEntity("Otilde", 213);
        SpecialEntity.addEntity("Ouml", 214);
        SpecialEntity.addEntity("times", 215);
        SpecialEntity.addEntity("Oslash", 216);
        SpecialEntity.addEntity("Ugrave", 217);
        SpecialEntity.addEntity("Uacute", 218);
        SpecialEntity.addEntity("Ucirc", 219);
        SpecialEntity.addEntity("Uuml", 220);
        SpecialEntity.addEntity("Yacute", 221);
        SpecialEntity.addEntity("THORN", 222);
        SpecialEntity.addEntity("szlig", 223);
        SpecialEntity.addEntity("agrave", 224);
        SpecialEntity.addEntity("aacute", 225);
        SpecialEntity.addEntity("acirc", 226);
        SpecialEntity.addEntity("atilde", 227);
        SpecialEntity.addEntity("auml", 228);
        SpecialEntity.addEntity("aring", 229);
        SpecialEntity.addEntity("aelig", 230);
        SpecialEntity.addEntity("ccedil", 231);
        SpecialEntity.addEntity("egrave", 232);
        SpecialEntity.addEntity("eacute", 233);
        SpecialEntity.addEntity("ecirc", 234);
        SpecialEntity.addEntity("euml", 235);
        SpecialEntity.addEntity("igrave", 236);
        SpecialEntity.addEntity("iacute", 237);
        SpecialEntity.addEntity("icirc", 238);
        SpecialEntity.addEntity("iuml", 239);
        SpecialEntity.addEntity("eth", 240);
        SpecialEntity.addEntity("ntilde", 241);
        SpecialEntity.addEntity("ograve", 242);
        SpecialEntity.addEntity("oacute", 243);
        SpecialEntity.addEntity("ocirc", 244);
        SpecialEntity.addEntity("otilde", 245);
        SpecialEntity.addEntity("ouml", 246);
        SpecialEntity.addEntity("divide", 247);
        SpecialEntity.addEntity("oslash", 248);
        SpecialEntity.addEntity("ugrave", 249);
        SpecialEntity.addEntity("uacute", 250);
        SpecialEntity.addEntity("ucirc", 251);
        SpecialEntity.addEntity("uuml", 252);
        SpecialEntity.addEntity("yacute", 253);
        SpecialEntity.addEntity("thorn", 254);
        SpecialEntity.addEntity("yuml", 255);
        SpecialEntity.addEntity("OElig", 338);
        SpecialEntity.addEntity("oelig", 339);
        SpecialEntity.addEntity("Scaron", 352);
        SpecialEntity.addEntity("scaron", 353);
        SpecialEntity.addEntity("Yuml", 376);
        SpecialEntity.addEntity("fnof", 402);
        SpecialEntity.addEntity("circ", 710);
        SpecialEntity.addEntity("tilde", 732);
        SpecialEntity.addEntity("Alpha", 913);
        SpecialEntity.addEntity("Beta", 914);
        SpecialEntity.addEntity("Gamma", 915);
        SpecialEntity.addEntity("Delta", 916);
        SpecialEntity.addEntity("Epsilon", 917);
        SpecialEntity.addEntity("Zeta", 918);
        SpecialEntity.addEntity("Eta", 919);
        SpecialEntity.addEntity("Theta", 920);
        SpecialEntity.addEntity("Iota", 921);
        SpecialEntity.addEntity("Kappa", 922);
        SpecialEntity.addEntity("Lambda", 923);
        SpecialEntity.addEntity("Mu", 924);
        SpecialEntity.addEntity("Nu", 925);
        SpecialEntity.addEntity("Xi", 926);
        SpecialEntity.addEntity("Omicron", 927);
        SpecialEntity.addEntity("Pi", 928);
        SpecialEntity.addEntity("Rho", 929);
        SpecialEntity.addEntity("Sigma", 931);
        SpecialEntity.addEntity("Tau", 932);
        SpecialEntity.addEntity("Upsilon", 933);
        SpecialEntity.addEntity("Phi", 934);
        SpecialEntity.addEntity("Chi", 935);
        SpecialEntity.addEntity("Psi", 936);
        SpecialEntity.addEntity("Omega", 937);
        SpecialEntity.addEntity("alpha", 945);
        SpecialEntity.addEntity("beta", 946);
        SpecialEntity.addEntity("gamma", 947);
        SpecialEntity.addEntity("delta", 948);
        SpecialEntity.addEntity("epsilon", 949);
        SpecialEntity.addEntity("zeta", 950);
        SpecialEntity.addEntity("eta", 951);
        SpecialEntity.addEntity("theta", 952);
        SpecialEntity.addEntity("iota", 953);
        SpecialEntity.addEntity("kappa", 954);
        SpecialEntity.addEntity("lambda", 955);
        SpecialEntity.addEntity("mu", 956);
        SpecialEntity.addEntity("nu", 957);
        SpecialEntity.addEntity("xi", 958);
        SpecialEntity.addEntity("omicron", 959);
        SpecialEntity.addEntity("pi", 960);
        SpecialEntity.addEntity("rho", 961);
        SpecialEntity.addEntity("sigmaf", 962);
        SpecialEntity.addEntity("sigma", 963);
        SpecialEntity.addEntity("tau", 964);
        SpecialEntity.addEntity("upsilon", 965);
        SpecialEntity.addEntity("phi", 966);
        SpecialEntity.addEntity("chi", 967);
        SpecialEntity.addEntity("psi", 968);
        SpecialEntity.addEntity("omega", 969);
        SpecialEntity.addEntity("thetasym", 977);
        SpecialEntity.addEntity("upsih", 978);
        SpecialEntity.addEntity("piv", 982);
        SpecialEntity.addEntity("ensp", 8194);
        SpecialEntity.addEntity("emsp", 8195);
        SpecialEntity.addEntity("thinsp", 8201);
        SpecialEntity.addEntity("zwnj", 8204);
        SpecialEntity.addEntity("zwj", 8205);
        SpecialEntity.addEntity("lrm", 8206);
        SpecialEntity.addEntity("rlm", 8207);
        SpecialEntity.addEntity("ndash", 8211);
        SpecialEntity.addEntity("mdash", 8212);
        SpecialEntity.addEntity("lsquo", 8216);
        SpecialEntity.addEntity("rsquo", 8217);
        SpecialEntity.addEntity("sbquo", 8218);
        SpecialEntity.addEntity("ldquo", 8220);
        SpecialEntity.addEntity("rdquo", 8221);
        SpecialEntity.addEntity("bdquo", 8222);
        SpecialEntity.addEntity("dagger", 8224);
        SpecialEntity.addEntity("Dagger", 8225);
        SpecialEntity.addEntity("bull", 8226);
        SpecialEntity.addEntity("hellip", 8230);
        SpecialEntity.addEntity("permil", 8240);
        SpecialEntity.addEntity("prime", 8242);
        SpecialEntity.addEntity("Prime", 8243);
        SpecialEntity.addEntity("lsaquo", 8249);
        SpecialEntity.addEntity("rsaquo", 8250);
        SpecialEntity.addEntity("oline", 8254);
        SpecialEntity.addEntity("frasl", 8260);
        SpecialEntity.addEntity("euro", 8364);
        SpecialEntity.addEntity("image", 8465);
        SpecialEntity.addEntity("weierp", 8472);
        SpecialEntity.addEntity("real", 8476);
        SpecialEntity.addEntity("trade", 8482);
        SpecialEntity.addEntity("alefsym", 8501);
        SpecialEntity.addEntity("larr", 8592);
        SpecialEntity.addEntity("uarr", 8593);
        SpecialEntity.addEntity("rarr", 8594);
        SpecialEntity.addEntity("darr", 8595);
        SpecialEntity.addEntity("harr", 8596);
        SpecialEntity.addEntity("crarr", 8629);
        SpecialEntity.addEntity("lArr", 8656);
        SpecialEntity.addEntity("uArr", 8657);
        SpecialEntity.addEntity("rArr", 8658);
        SpecialEntity.addEntity("dArr", 8659);
        SpecialEntity.addEntity("hArr", 8660);
        SpecialEntity.addEntity("forall", 8704);
        SpecialEntity.addEntity("part", 8706);
        SpecialEntity.addEntity("exist", 8707);
        SpecialEntity.addEntity("empty", 8709);
        SpecialEntity.addEntity("nabla", 8711);
        SpecialEntity.addEntity("isin", 8712);
        SpecialEntity.addEntity("notin", 8713);
        SpecialEntity.addEntity("ni", 8715);
        SpecialEntity.addEntity("prod", 8719);
        SpecialEntity.addEntity("sum", 8721);
        SpecialEntity.addEntity("minus", 8722);
        SpecialEntity.addEntity("lowast", 8727);
        SpecialEntity.addEntity("radic", 8730);
        SpecialEntity.addEntity("prop", 8733);
        SpecialEntity.addEntity("infin", 8734);
        SpecialEntity.addEntity("ang", 8736);
        SpecialEntity.addEntity("and", 8743);
        SpecialEntity.addEntity("or", 8744);
        SpecialEntity.addEntity("cap", 8745);
        SpecialEntity.addEntity("cup", 8746);
        SpecialEntity.addEntity("int", 8747);
        SpecialEntity.addEntity("there4", 8756);
        SpecialEntity.addEntity("sim", 8764);
        SpecialEntity.addEntity("cong", 8773);
        SpecialEntity.addEntity("asymp", 8776);
        SpecialEntity.addEntity("ne", 8800);
        SpecialEntity.addEntity("equiv", 8801);
        SpecialEntity.addEntity("le", 8804);
        SpecialEntity.addEntity("ge", 8805);
        SpecialEntity.addEntity("sub", 8834);
        SpecialEntity.addEntity("sup", 8835);
        SpecialEntity.addEntity("nsub", 8836);
        SpecialEntity.addEntity("sube", 8838);
        SpecialEntity.addEntity("supe", 8839);
        SpecialEntity.addEntity("oplus", 8853);
        SpecialEntity.addEntity("otimes", 8855);
        SpecialEntity.addEntity("perp", 8869);
        SpecialEntity.addEntity("sdot", 8901);
        SpecialEntity.addEntity("lceil", 8968);
        SpecialEntity.addEntity("rceil", 8969);
        SpecialEntity.addEntity("lfloor", 8970);
        SpecialEntity.addEntity("rfloor", 8971);
        SpecialEntity.addEntity("lang", 9001);
        SpecialEntity.addEntity("rang", 9002);
        SpecialEntity.addEntity("loz", 9674);
        SpecialEntity.addEntity("spades", 9824);
        SpecialEntity.addEntity("clubs", 9827);
        SpecialEntity.addEntity("hearts", 9829);
        SpecialEntity.addEntity("diams", 9830);
    }
}

