/* psn.h
 */
#ifndef OSL_PSN_H
#define OSL_PSN_H

#include "osl/move.h"
#include <string>
#include <stdexcept>
namespace osl
{
  namespace state
  {
    class SimpleState;
  }
  namespace record
  {
    /**
     * gnushogi で使われるフォーマット.
     * 何種類かある．
     */
    namespace psn
    {
      class ParseError : public std::invalid_argument
      {
      public:
        ParseError(const std::string& msg = "")
          : invalid_argument(msg)
        { }
      };
      const Move strToMove(const std::string&, const state::SimpleState&);
      const Square strToPos(const std::string&);
      Ptype charToPtype(char);

      const std::string show(Move);
      const std::string show(Square);
      char show(Ptype);

      /** decorate capture by 'x', promote by '+', and unpromote by '=' */
      const std::string showXP(Move);
    }
  } // record
} // osl


#endif /* OSL_PSN_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
