set(_glog_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES ${CMAKE_FIND_LIBRARY_SUFFIXES})

find_path(Glog_INCLUDE_PATH glog/logging.h)

if (Glog_STATIC)
  if (WIN32)
    set(CMAKE_FIND_LIBRARY_SUFFIXES .lib ${CMAKE_FIND_LIBRARY_SUFFIXES})
  else (WIN32)
    set(CMAKE_FIND_LIBRARY_SUFFIXES .a ${CMAKE_FIND_LIBRARY_SUFFIXES})
  endif (WIN32)
endif (Glog_STATIC)
find_library(Glog_LIBRARY NAMES glog libglog)
if(Glog_INCLUDE_PATH AND Glog_LIBRARY)
  set(Glog_FOUND TRUE)
endif(Glog_INCLUDE_PATH AND Glog_LIBRARY)
if(Glog_FOUND)
  if(NOT Glog_FIND_QUIETLY)
    message(STATUS "Found glog: ${Glog_LIBRARY}")
  endif(NOT Glog_FIND_QUIETLY)
else(Glog_FOUND)
  if(Glog_FIND_REQUIRED)
    message(FATAL_ERROR "Could not find glog library.")
  endif(Glog_FIND_REQUIRED)
endif(Glog_FOUND)

set(CMAKE_FIND_LIBRARY_SUFFIXES ${_glog_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES})
