set(_kyotocabinet_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES ${CMAKE_FIND_LIBRARY_SUFFIXES})

find_path(KyotoCabinet_INCLUDE_PATH kccommon.h)

if (KyotoCabinet_STATIC)
  if (WIN32)
    set(CMAKE_FIND_LIBRARY_SUFFIXES .lib ${CMAKE_FIND_LIBRARY_SUFFIXES})
  else (WIN32)
    set(CMAKE_FIND_LIBRARY_SUFFIXES .a ${CMAKE_FIND_LIBRARY_SUFFIXES})
  endif (WIN32)
endif (KyotoCabinet_STATIC)
find_library(KyotoCabinet_LIBRARY NAMES kyotocabinet)
if(KyotoCabinet_INCLUDE_PATH AND KyotoCabinet_LIBRARY)
  set(KyotoCabinet_FOUND TRUE)
endif(KyotoCabinet_INCLUDE_PATH AND KyotoCabinet_LIBRARY)
if(KyotoCabinet_FOUND)
  if(NOT KyotoCabinet_FIND_QUIETLY)
    message(STATUS "Found kyotocabinet: ${KyotoCabinet_LIBRARY}")
  endif(NOT KyotoCabinet_FIND_QUIETLY)
else(KyotoCabinet_FOUND)
  if(KyotoCabinet_FIND_REQUIRED)
    message(FATAL_ERROR "Could not find kyotocabinet library.")
  endif(KyotoCabinet_FIND_REQUIRED)
endif(KyotoCabinet_FOUND)

set(CMAKE_FIND_LIBRARY_SUFFIXES ${_kyotocabinet_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES})
