/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom.css;

import org.w3c.dom.DOMException;
import sun.plugin.dom.css.CSSPrimitiveValue;
import sun.plugin.dom.css.CSSStyleDeclaration;
import sun.plugin.dom.css.CSSValueList;
import sun.plugin.dom.exception.InvalidStateException;
import sun.plugin.dom.exception.NoModificationAllowedException;

public abstract class CSSValue
implements org.w3c.dom.css.CSSValue {
    protected String cssText = null;
    private String propertyName = null;
    private CSSStyleDeclaration css = null;
    private CSSValue parentCSSValue = null;

    protected CSSValue(CSSStyleDeclaration cSSStyleDeclaration, String string) {
        this.css = cSSStyleDeclaration;
        this.propertyName = string;
    }

    protected CSSValue(CSSValue cSSValue) {
        this.parentCSSValue = cSSValue;
    }

    public String getCssText() {
        return this.cssText;
    }

    public void setCssText(String string) throws DOMException {
        CSSValue cSSValue;
        CSSValue cSSValue2 = null;
        cSSValue2 = this.parentCSSValue != null ? CSSValue.newCSSValue(this.parentCSSValue, string) : CSSValue.newCSSValue(this.css, this.propertyName, string);
        if (this.isSameType(cSSValue2)) {
            this.copy(cSSValue2);
            this.cssText = string;
            cSSValue = this;
            while (cSSValue.parentCSSValue != null) {
                cSSValue = cSSValue.parentCSSValue;
            }
        } else {
            throw new NoModificationAllowedException("Can not set cssText: " + string);
        }
        cSSValue.updateProperty();
    }

    public String toString() {
        return this.cssText;
    }

    protected void updateProperty() {
        this.css.setProperty(this.propertyName, this.toString(), null);
    }

    protected abstract boolean isSameType(CSSValue var1);

    protected void copy(CSSValue cSSValue) {
        this.cssText = cSSValue.cssText;
    }

    public static CSSValue newCSSValue(CSSValue cSSValue, String string) throws DOMException {
        String string2 = string.trim();
        if (CSSValue.hasMultipleValues(string2)) {
            return CSSValueList.newCSSValueList(cSSValue, string2);
        }
        return CSSPrimitiveValue.newCSSPrimitiveValue(cSSValue, string2);
    }

    public static CSSValue newCSSValue(CSSStyleDeclaration cSSStyleDeclaration, String string, String string2) throws DOMException {
        String string3 = string2.trim();
        System.out.println("New CSSValue for " + string + " = " + string2);
        if (CSSValue.hasMultipleValues(string3)) {
            return CSSValueList.newCSSValueList(cSSStyleDeclaration, string, string3);
        }
        return CSSPrimitiveValue.newCSSPrimitiveValue(cSSStyleDeclaration, string, string3);
    }

    private static boolean hasMultipleValues(String string) throws DOMException {
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    return true;
                }
                case '(': {
                    i = string.indexOf(")", i + 1);
                    if (i != -1) continue block5;
                    throw new InvalidStateException("Invalid cssText: " + string);
                }
                case '\"': {
                    i = string.indexOf("\"", i + 1);
                    if (i != -1) continue block5;
                    throw new InvalidStateException("Invalid cssText: " + string);
                }
            }
        }
        return false;
    }
}

