/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MAINPROXY_H
#define MAINPROXY_H

#include <QTimeLine>
#include <QGraphicsProxyWidget>

class mainProxy : public QGraphicsProxyWidget
{
	Q_OBJECT
public:
	mainProxy(QGraphicsItem *parent = 0, Qt::WindowFlags wFlags = 0);

	QRectF boundingRect() const;
	void paintWindowFrame(QPainter *painter, const QStyleOptionGraphicsItem *option,QWidget *widget);

protected:
	void hoverEnterEvent(QGraphicsSceneHoverEvent *event);
	void hoverLeaveEvent(QGraphicsSceneHoverEvent *event);
	bool sceneEventFilter(QGraphicsItem *watched, QEvent *event);
	QVariant itemChange(GraphicsItemChange change, const QVariant &value);

private slots:
	void updateStep(qreal step);
	void stateChanged(QTimeLine::State);
	void zoomIn();
	void zoomOut();

private:
	QTimeLine *timeLine;
	bool popupShown;
};

#endif
