/*
 * Collection of filters to modify streams of tagged items
 *
 * Copyright (C) 2003,2004,2005,2006  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tests/test-utils.h>
#include <tagcoll/stream/sink.h>

namespace tut {
using namespace tagcoll::tests;

struct tagcoll_stream_sink_shar {
};
TESTGRP(tagcoll_stream_sink);

template<> template<>
void to::test<1>()
{
	std::string input_coll(
			"a: 1, 2\n"
			"b: \n"
			"c: 2, 3\n"
			);
	int countItems = 0, countTags = 0;
	parseCollection(input_coll, tagcoll::stream::countingSink(countItems, countTags));

	ensure_equals(countItems, 3);
	ensure_equals(countTags, 4);
}

}

#include <tagcoll/TextFormat.tcc>

// vim:set ts=4 sw=4:
