from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


aliases = _Mock()

base_aliases = _Mock()

base_flags = _Mock()

cast_bytes = _Mock()

catch_config_error = _Mock()

disambiguate_ip_address = _Mock()

flags = _Mock()

import_item = _Mock()

ioloop = _Mock()

json = _Mock()

launch_new_instance = _Mock()

os = _Mock()

session_aliases = _Mock()

session_flags = _Mock()

sys = _Mock()

time = _Mock()

zmq = _Mock()

_description = 'Start an IPython engine for parallel computing.\n\nIPython engines run in parallel and perform computations on behalf of a client\nand controller. A controller needs to be started before the engines. The\nengine can be configured using command line options or using a cluster\ndirectory. Cluster directories contain config, log and security files and are\nusually located in your ipython directory and named as "profile_name".\nSee the `profile` and `profile-dir` options for details.\n'

_examples = '\nipengine --ip=192.168.0.1 --port=1000     # connect to hub at ip and port\nipengine --log-to-file --log-level=DEBUG  # log to a file with DEBUG verbosity\n'

mpi4py_init = 'from mpi4py import MPI as mpi\nmpi.size = mpi.COMM_WORLD.Get_size()\nmpi.rank = mpi.COMM_WORLD.Get_rank()\n'

pytrilinos_init = 'from PyTrilinos import Epetra\nclass SimpleStruct:\npass\nmpi = SimpleStruct()\nmpi.rank = 0\nmpi.size = 0\n'

class BaseParallelApplication(_Mock):
  pass
  _in_init_profile_dir = False

class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class Configurable(_Mock):
  pass


class Dict(_Mock):
  pass
  info_text = 'any value'

class EngineFactory(_Mock):
  pass
  _hb_last_monitored = 0.0
  _hb_last_pinged = 0.0
  _hb_missed_beats = 0

class EnginePUBHandler(_Mock):
  pass


class Float(_Mock):
  pass
  default_value = 0.0
  info_text = 'a float'

class IPEngineApp(_Mock):
  pass
  _in_init_profile_dir = False
  description = 'Start an IPython engine for parallel computing.\n\nIPython engines run in parallel and perform computations on behalf of a client\nand controller. A controller needs to be started before the engines. The\nengine can be configured using command line options or using a cluster\ndirectory. Cluster directories contain config, log and security files and are\nusually located in your ipython directory and named as "profile_name".\nSee the `profile` and `profile-dir` options for details.\n'
  examples = '\nipengine --ip=192.168.0.1 --port=1000     # connect to hub at ip and port\nipengine --log-to-file --log-level=DEBUG  # log to a file with DEBUG verbosity\n'
  name = 'ipengine'

class IPKernelApp(_Mock):
  pass
  _in_init_profile_dir = False
  name = 'ipkernel'

class Instance(_Mock):
  pass
  info_text = 'any value'

class Kernel(_Mock):
  pass


class List(_Mock):
  pass
  info_text = 'any value'

class MPI(_Mock):
  pass


class ProfileDir(_Mock):
  pass


class Session(_Mock):
  pass


class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

class ZMQInteractiveShell(_Mock):
  pass
  default_user_namespaces = True

