from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


ANCHOR_OFFSETS = _Mock()

COLORS = _Mock()

CONF = _Mock()

MARKERS = _Mock()

_ = _Mock()

arange = _Mock()

array = _Mock()

is_text_string = _Mock()

lut_range_threshold = _Mock()

make = _Mock()

make_title = _Mock()

meshgrid = _Mock()

osp = _Mock()

style_generator = _Mock()

update_style_attr = _Mock()

zeros = _Mock()

CURVE_COUNT = 0

HISTOGRAM2D_COUNT = 0

HISTOGRAM_COUNT = 0

IMAGE_COUNT = 0

LABEL_COUNT = 0

class AnnotatedEllipse(_Mock):
  pass
  AutoScale = 2
  LABEL_ANCHOR = u'C'
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class AnnotatedRectangle(_Mock):
  pass
  AutoScale = 2
  LABEL_ANCHOR = u'TL'
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class AnnotatedSegment(_Mock):
  pass
  AutoScale = 2
  LABEL_ANCHOR = u'C'
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class AnnotationParam(_Mock):
  pass


class BasePlot(_Mock):
  pass
  BottomLegend = 2
  Box = 1
  DEFAULT_ACTIVE_XAXIS = 2
  DEFAULT_ACTIVE_YAXIS = 0
  DrawChildren = 2
  DrawWindowBackground = 1
  ExternalLegend = 4
  HLine = 4
  IgnoreMask = 4
  LeftLegend = 0
  NoFrame = 0
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  RightLegend = 1
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  TopLegend = 3
  VLine = 5
  WinPanel = 3
  X_BOTTOM = 2
  X_TOP = 3
  Y_LEFT = 0
  Y_RIGHT = 1
  axisCnt = 4
  xBottom = 2
  xTop = 3
  yLeft = 0
  yRight = 1

class CurveItem(_Mock):
  pass
  AutoScale = 2
  ClipPolygons = 2
  Dots = 4
  Fitted = 2
  Inverted = 1
  Legend = 1
  Lines = 1
  NoCurve = 0
  PaintFiltered = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  Steps = 3
  Sticks = 2
  UserCurve = 100
  Xfy = 1
  Yfx = 0
  _private = False
  _readonly = False

class CurveParam(_Mock):
  pass
  _multiselection = False

class DataInfoLabel(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _private = False
  _readonly = False

class EllipseShape(_Mock):
  pass
  ADDITIONNAL_POINTS = 0
  AutoScale = 2
  CLOSED = True
  LINK_ADDITIONNAL_POINTS = False
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class ErrorBarCurveItem(_Mock):
  pass
  AutoScale = 2
  ClipPolygons = 2
  Dots = 4
  Fitted = 2
  Inverted = 1
  Legend = 1
  Lines = 1
  NoCurve = 0
  PaintFiltered = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  Steps = 3
  Sticks = 2
  UserCurve = 100
  Xfy = 1
  Yfx = 0
  _private = False
  _readonly = False

class ErrorBarParam(_Mock):
  pass


class GridItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _private = False
  _readonly = True

class GridParam(_Mock):
  pass


class Histogram2DItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = False
  _can_resize = False
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False
  fill_canvas = True

class Histogram2DParam(_Mock):
  pass
  _hide_colormap = False
  _multiselection = False

class HistogramItem(_Mock):
  pass
  AutoScale = 2
  ClipPolygons = 2
  Dots = 4
  Fitted = 2
  Inverted = 1
  Legend = 1
  Lines = 1
  NoCurve = 0
  PaintFiltered = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  Steps = 3
  Sticks = 2
  UserCurve = 100
  Xfy = 1
  Yfx = 0
  _private = False
  _readonly = False

class HistogramParam(_Mock):
  pass


class ImageFilterParam(_Mock):
  pass
  _hide_colormap = False
  _multiselection = False

class ImageItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = False
  _can_resize = False
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class ImageParam(_Mock):
  pass
  _hide_background = False
  _hide_colormap = False
  _multiselection = False

class LabelItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _private = False
  _readonly = False

class LabelParam(_Mock):
  pass
  _legend = False
  _multiselection = False
  _no_contents = True

class LabelParamWithContents(_Mock):
  pass
  _legend = False
  _multiselection = False
  _no_contents = False

class LegendBoxItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _private = False
  _readonly = False

class LegendParam(_Mock):
  pass
  _legend = True
  _multiselection = False
  _no_contents = True

class LineStyleParam(_Mock):
  pass


class Marker(_Mock):
  pass
  AutoScale = 2
  Cross = 3
  HLine = 1
  Legend = 1
  NoLine = 0
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  VLine = 2
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = True

class MarkerParam(_Mock):
  pass


class MaskedImageItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = False
  _can_resize = False
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class MaskedImageParam(_Mock):
  pass
  _hide_background = False
  _hide_colormap = False
  _multiselection = False

class PlotItemBuilder(_Mock):
  pass


class QuadGridItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = False
  _can_resize = False
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class QuadGridParam(_Mock):
  pass
  _hide_colormap = False
  _multiselection = False

class RGBImageItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = False
  _can_resize = False
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class RGBImageParam(_Mock):
  pass
  _hide_background = True
  _hide_colormap = True
  _multiselection = False

class RangeComputation(_Mock):
  pass


class RangeComputation2d(_Mock):
  pass


class RangeInfo(_Mock):
  pass


class RectangleShape(_Mock):
  pass
  ADDITIONNAL_POINTS = 0
  AutoScale = 2
  CLOSED = True
  LINK_ADDITIONNAL_POINTS = False
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class SegmentShape(_Mock):
  pass
  ADDITIONNAL_POINTS = 1
  AutoScale = 2
  CLOSED = False
  LINK_ADDITIONNAL_POINTS = False
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class SelectedLegendBoxItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _private = False
  _readonly = False

class TrImageItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = True
  _can_select = True
  _private = False
  _readonly = False

class TrImageParam(_Mock):
  pass
  _hide_background = False
  _hide_colormap = False
  _multiselection = False

class XRangeSelection(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class XYImageItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = False
  _can_resize = False
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class XYImageParam(_Mock):
  pass
  _hide_background = False
  _hide_colormap = False
  _multiselection = False

class ndarray(_Mock):
  pass


