from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


absolute_import = _Mock()

import_item = _Mock()

is_local_ip = _Mock()

launch_kernel = _Mock()

local_ips = _Mock()

make_ipkernel_cmd = _Mock()

re = _Mock()

signal = _Mock()

sys = _Mock()

time = _Mock()

zmq = _Mock()



class Any(_Mock):
  pass
  info_text = 'any value'

class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class ConnectionFileMixin(_Mock):
  pass


class DottedObjectName(_Mock):
  pass
  info_text = 'a valid object identifier in Python'

class Instance(_Mock):
  pass
  info_text = 'any value'

class KernelManager(_Mock):
  pass


class KernelManagerABC(_Mock):
  pass
  _abc_negative_cache_version = 43

class List(_Mock):
  pass
  info_text = 'any value'

class LoggingConfigurable(_Mock):
  pass


class Session(_Mock):
  pass


class Type(_Mock):
  pass
  info_text = 'any value'

class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

