/*
 * This file is part of system-settings
 *
 * Copyright (C) 2013 Canonical Ltd.
 *
 * Contact: Sebastien Bacher <sebastien.bacher@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import GSettings 1.0
import QtQuick 2.0
import Ubuntu.Components 0.1
import Ubuntu.Components.ListItems 0.1 as ListItem
import SystemSettings 1.0
import Ubuntu.SystemSettings.Sound 1.0

import "utilities.js" as Utilities

ItemPage {
    id: root

    title: i18n.tr("Sound")
    flickable: scrollWidget

    UbuntuSoundPanel { id: backendInfo }

    GSettings {
        id: soundSettings
        schema.id: "com.ubuntu.touch.sound"
    }

    Flickable {
        id: scrollWidget
        anchors.fill: parent
        contentHeight: contentItem.childrenRect.height
        boundsBehavior: (contentHeight > root.height) ?
                            Flickable.DragAndOvershootBounds :
                            Flickable.StopAtBounds
        /* Set the direction to workaround https://bugreports.qt-project.org/browse/QTBUG-31905
           otherwise the UI might end up in a situation where scrolling doesn't work */
        flickableDirection: Flickable.VerticalFlick

        Column {
            anchors.left: parent.left
            anchors.right: parent.right

            SilentModeWarning { visible: backendInfo.silentMode }

            ListItem.Standard {
                text: i18n.tr("Phone calls:")
            }

            ListItem.SingleValue {
                text: i18n.tr("Ringtone")
                value: Utilities.buildDisplayName(
                           backendInfo.incomingCallSound)
                progression: true
                onClicked: pageStack.push(
                               Qt.resolvedUrl("SoundsList.qml"),
                               { title: i18n.tr("Ringtone"),
                                 showStopButton: true,
                                 soundType: 0,
                                 soundsDir:
                                   "/usr/share/sounds/ubuntu/ringtones/" })
            }

            ListItem.Standard {
                control: CheckBox {
                    checked: false
                }
                text: i18n.tr("Vibrate when ringing")
                visible: showAllUI
            }

            ListItem.Standard {
                control: CheckBox {
                    checked: false
                }
                text: i18n.tr("Vibrate in Silent Mode")
                visible: showAllUI
            }

            ListItem.Standard {
                text: i18n.tr("Messages:")
            }

            ListItem.SingleValue {
                text: i18n.tr("Message received")
                value:Utilities.buildDisplayName(
                          backendInfo.incomingMessageSound)
                progression: true
                onClicked: pageStack.push(
                               Qt.resolvedUrl("SoundsList.qml"),
                               { title: i18n.tr("Message received"),
                                  soundType: 1,
                                 soundsDir:
                                   "/usr/share/sounds/ubuntu/notifications/" })
            }

            ListItem.Standard {
                control: CheckBox {
                    checked: false
                }
                text: i18n.tr("Vibrate with message sound")
                visible: showAllUI
            }

            ListItem.Standard {
                control: CheckBox {
                    checked: false
                }
                text: i18n.tr("Vibrate in Silent Mode")
                visible: showAllUI
            }

            ListItem.Standard {
                text: i18n.tr("Other sounds:")
                visible: showAllUI
            }

            ListItem.Standard {
                control: Switch {
                    checked: false
                }
                text: i18n.tr("Keyboard sound")
                visible: showAllUI
            }

            ListItem.Standard {
                control: Switch {
                    checked: false
                }
                text: i18n.tr("Lock sound")
                visible: showAllUI
            }
        }
    }
}
