/*
 * Copyright (C) 2019 Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/&gt;.
 *
 */

#include "user_conf.h"

#define LIGHTDM_CONF_FILE    "/etc/lightdm/lightdm.conf"
#define UKUI_GREETER_CONF_FILE  "/var/lib/lightdm/.cache/ukui-greeter.conf"

//存放于用户目录 /home/username/.config/audio.json

UserConf::UserConf(QObject *parent)
    : QObject(parent)
{
}

QJsonValue UserConf::readJson(QString username,QString jsonFile,QString key)
{
    QString filename = username;
    filename += jsonFile;
    syslog(LOG_INFO, "readJson  filename %s, user: %s, jsonfile:%s", filename.toLatin1().data(), username.toLatin1().data(), jsonFile.toLatin1().data());

    QFile file(filename);
    if (!file.open(QFile::ReadOnly | QFile::Text)) {
        syslog(LOG_INFO, "can't open error :%s", strerror(errno));
        return DEFAULT_AUDIO_DEV;
    }

    // 读取文件的全部内容
    QTextStream stream(&file);
    stream.setCodec("UTF-8");		// 设置读取编码是UTF8
    QString str = stream.readAll();

    file.close();

    // QJsonParseError类用于在JSON解析期间报告错误。
    QJsonParseError jsonError;
    // 将json解析为UTF-8编码的json文档，并从中创建一个QJsonDocument。
    // 如果解析成功，返回QJsonDocument对象，否则返回null
    QJsonDocument doc = QJsonDocument::fromJson(str.toUtf8(), &jsonError);
    // 判断是否解析失败
    if (jsonError.error != QJsonParseError::NoError && !doc.isNull()) {
        syslog(LOG_INFO,"Json格式错误！%s",jsonError.error);
        return DEFAULT_AUDIO_DEV;
    }

    QJsonObject rootObj = doc.object();

    //获取键值对
    QJsonValue card = rootObj.value(key);

    return card;
}

void UserConf::insertJson()
{
    QJsonObject rootObj;
    // 插入元素

    rootObj.insert("First", "yes"); //是否为第一次开机
    // 将json对象里的数据转换为字符串
    QJsonDocument doc;
    // 将object设置为本文档的主要对象
    doc.setObject(rootObj);

    QFile file("/tmp/PlayStartupWav.json");
    if (!file.open(QIODevice::WriteOnly | QIODevice::Truncate)) {
        syslog (LOG_INFO,"can't open error!");
        return;
    }

    QTextStream stream(&file);
    stream.setCodec("UTF-8");		// 设置写入编码是UTF8
    // 写入文件
    stream << doc.toJson();
    file.close();

}

QString UserConf::readLightdmConf()
{
    //Qt中使用QSettings类读写conf文件
    //QSettings构造函数的第一个参数是conf文件的路径,第二个参数表示针对conf文件,第三个参数可以省略
    settings = new QSettings(LIGHTDM_CONF_FILE,QSettings::IniFormat);

    // 通过value获取值
    // 格式： settings->value(""节名/键名"");
    settings->value("SeatDefaults/autologin-user");

    return settings->value("SeatDefaults/autologin-user").toString();
}

QString UserConf::readLastUser()
{
    //Qt中使用QSettings类读写conf文件
    //QSettings构造函数的第一个参数是conf文件的路径,第二个参数表示针对conf文件,第三个参数可以省略
    settings = new QSettings(UKUI_GREETER_CONF_FILE,QSettings::IniFormat);

    // 通过value获取值   格式： settings->value(""节名/键名"");
    settings->value("Greeter/lastLoginUser");

    qDebug() << "lastLoginUser" << settings->value("Greeter/lastLoginUser").toString();
    syslog(LOG_DEBUG,"lastLoginUser :%s", settings->value("Greeter/lastLoginUser").toString().toLatin1().data());
    return settings->value("Greeter/lastLoginUser").toString();
}

UserConf::~UserConf()
{
}

