/* valadatatype.c generated by valac, the Vala compiler
 * generated from valadatatype.vala, do not modify */

/* valadatatype.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_scope_unref0(var) ((var == NULL) ? NULL : (var = (vala_scope_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _ValaDataTypePrivate {
	gboolean _value_owned;
	gboolean _nullable;
	ValaSymbol* _symbol;
	gboolean _floating_reference;
	gboolean _is_dynamic;
	ValaList* type_argument_list;
};

static gint ValaDataType_private_offset;
static gpointer vala_data_type_parent_class = NULL;
static ValaList* vala_data_type__empty_type_list;
static ValaList* vala_data_type__empty_type_list = NULL;

static void vala_data_type_set_symbol (ValaDataType* self,
                                ValaSymbol* value);
static void vala_data_type_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_data_type_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gchar* vala_data_type_real_to_string (ValaCodeNode* base);
static gchar* vala_data_type_real_to_qualified_string (ValaDataType* self,
                                                ValaScope* scope);
static ValaDataType* vala_data_type_real_copy (ValaDataType* self);
static gboolean vala_data_type_real_equals (ValaDataType* self,
                                     ValaDataType* type2);
static gboolean vala_data_type_real_stricter (ValaDataType* self,
                                       ValaDataType* type2);
static void vala_data_type_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static gboolean vala_data_type_real_compatible (ValaDataType* self,
                                         ValaDataType* target_type);
G_GNUC_INTERNAL ValaDataType* vala_semantic_analyzer_get_instance_base_type_for_member (ValaDataType* derived_instance_type,
                                                                        ValaTypeSymbol* type_symbol,
                                                                        ValaCodeNode* node_reference);
static gboolean vala_data_type_real_is_invokable (ValaDataType* self);
static ValaDataType* vala_data_type_real_get_return_type (ValaDataType* self);
static ValaList* vala_data_type_real_get_parameters (ValaDataType* self);
static gboolean vala_data_type_real_is_reference_type_or_type_parameter (ValaDataType* self);
static gboolean vala_data_type_real_is_accessible (ValaDataType* self,
                                            ValaSymbol* sym);
static ValaSymbol* vala_data_type_real_get_member (ValaDataType* self,
                                            const gchar* member_name);
static ValaSymbol* vala_data_type_real_get_pointer_member (ValaDataType* self,
                                                    const gchar* member_name);
static gboolean vala_data_type_real_is_real_struct_type (ValaDataType* self);
static gboolean vala_data_type_real_is_disposable (ValaDataType* self);
static ValaDataType* vala_data_type_real_get_actual_type (ValaDataType* self,
                                                   ValaDataType* derived_instance_type,
                                                   ValaList* method_type_arguments,
                                                   ValaCodeNode* node_reference);
static ValaDataType* vala_data_type_real_infer_type_argument (ValaDataType* self,
                                                       ValaTypeParameter* type_param,
                                                       ValaDataType* value_type);
static gchar* vala_data_type_real_to_prototype_string (ValaDataType* self,
                                                const gchar* override_name);
static void vala_data_type_finalize (ValaCodeNode * obj);
static GType vala_data_type_get_type_once (void);

static inline gpointer
vala_data_type_get_instance_private (ValaDataType* self)
{
	return G_STRUCT_MEMBER_P (self, ValaDataType_private_offset);
}

gboolean
vala_data_type_get_value_owned (ValaDataType* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_value_owned;
	return result;
}

void
vala_data_type_set_value_owned (ValaDataType* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_value_owned = value;
}

gboolean
vala_data_type_get_nullable (ValaDataType* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_nullable;
	return result;
}

void
vala_data_type_set_nullable (ValaDataType* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_nullable = value;
}

ValaSymbol*
vala_data_type_get_symbol (ValaDataType* self)
{
	ValaSymbol* result;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_symbol;
	result = _tmp0_;
	return result;
}

static void
vala_data_type_set_symbol (ValaDataType* self,
                           ValaSymbol* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_symbol = value;
}

ValaTypeSymbol*
vala_data_type_get_type_symbol (ValaDataType* self)
{
	ValaTypeSymbol* result;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_symbol;
	result = VALA_IS_TYPESYMBOL (_tmp0_) ? ((ValaTypeSymbol*) _tmp0_) : NULL;
	return result;
}

gboolean
vala_data_type_get_floating_reference (ValaDataType* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_floating_reference;
	return result;
}

void
vala_data_type_set_floating_reference (ValaDataType* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_floating_reference = value;
}

gboolean
vala_data_type_get_is_dynamic (ValaDataType* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_dynamic;
	return result;
}

void
vala_data_type_set_is_dynamic (ValaDataType* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_dynamic = value;
}

ValaDataType*
vala_data_type_construct_with_symbol (GType object_type,
                                      ValaSymbol* symbol)
{
	ValaDataType* self = NULL;
	self = (ValaDataType*) vala_code_node_construct (object_type);
	vala_data_type_set_symbol (self, symbol);
	return self;
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_data_type_add_type_argument (ValaDataType* self,
                                  ValaDataType* arg)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_argument_list);
		self->priv->type_argument_list = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp3_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_data_type_get_type_arguments (ValaDataType* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->type_argument_list;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_data_type__empty_type_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_data_type__empty_type_list);
		vala_data_type__empty_type_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_data_type__empty_type_list;
	result = _tmp5_;
	return result;
}

gboolean
vala_data_type_has_type_arguments (ValaDataType* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->type_argument_list;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->type_argument_list;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_ > 0;
	return result;
}

/**
 * Removes all generic type arguments.
 */
void
vala_data_type_remove_all_type_arguments (ValaDataType* self)
{
	g_return_if_fail (self != NULL);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	self->priv->type_argument_list = NULL;
}

static void
vala_data_type_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaDataType * self;
	self = (ValaDataType*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_data_type (visitor, self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_data_type_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaDataType * self;
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	self = (ValaDataType*) base;
	g_return_if_fail (visitor != NULL);
	_tmp1_ = self->priv->type_argument_list;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_argument_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp5_;
			ValaList* _tmp6_;
			gint _type_arg_size = 0;
			ValaList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _type_arg_index = 0;
			_tmp5_ = self->priv->type_argument_list;
			_tmp6_ = _vala_iterable_ref0 (_tmp5_);
			_type_arg_list = _tmp6_;
			_tmp7_ = _type_arg_list;
			_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_type_arg_size = _tmp9_;
			_type_arg_index = -1;
			while (TRUE) {
				ValaDataType* type_arg = NULL;
				ValaList* _tmp10_;
				gpointer _tmp11_;
				ValaDataType* _tmp12_;
				_type_arg_index = _type_arg_index + 1;
				if (!(_type_arg_index < _type_arg_size)) {
					break;
				}
				_tmp10_ = _type_arg_list;
				_tmp11_ = vala_list_get (_tmp10_, _type_arg_index);
				type_arg = (ValaDataType*) _tmp11_;
				_tmp12_ = type_arg;
				vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
	}
}

static gchar*
vala_data_type_real_to_string (ValaCodeNode* base)
{
	ValaDataType * self;
	gchar* _tmp0_;
	gchar* result = NULL;
	self = (ValaDataType*) base;
	_tmp0_ = vala_data_type_to_qualified_string (self, NULL);
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_scope_ref0 (gpointer self)
{
	return self ? vala_scope_ref (self) : NULL;
}

static gchar*
vala_data_type_real_to_qualified_string (ValaDataType* self,
                                         ValaScope* scope)
{
	gchar* s = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaList* type_args = NULL;
	ValaList* _tmp44_;
	ValaList* _tmp45_;
	ValaList* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	gboolean _tmp70_;
	gchar* result = NULL;
	_tmp0_ = vala_data_type_get_type_symbol (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSymbol* global_symbol = NULL;
		ValaTypeSymbol* _tmp2_;
		ValaTypeSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		ValaSymbol* sym = NULL;
		ValaScope* parent_scope = NULL;
		ValaScope* _tmp18_;
		gboolean _tmp31_ = FALSE;
		ValaSymbol* _tmp32_;
		_tmp2_ = vala_data_type_get_type_symbol (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp3_);
		global_symbol = _tmp4_;
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			ValaSymbol* _tmp6_;
			ValaSymbol* _tmp7_;
			ValaSymbol* _tmp8_;
			ValaSymbol* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaSymbol* _tmp17_;
			_tmp6_ = global_symbol;
			_tmp7_ = vala_symbol_get_parent_symbol (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_ != NULL) {
				ValaSymbol* _tmp9_;
				ValaSymbol* _tmp10_;
				ValaSymbol* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp9_ = global_symbol;
				_tmp10_ = vala_symbol_get_parent_symbol (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_symbol_get_name (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp5_ = _tmp13_ != NULL;
			} else {
				_tmp5_ = FALSE;
			}
			if (!_tmp5_) {
				break;
			}
			_tmp14_ = global_symbol;
			_tmp15_ = vala_symbol_get_parent_symbol (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _vala_code_node_ref0 (_tmp16_);
			_vala_code_node_unref0 (global_symbol);
			global_symbol = _tmp17_;
		}
		sym = NULL;
		_tmp18_ = _vala_scope_ref0 (scope);
		parent_scope = _tmp18_;
		while (TRUE) {
			gboolean _tmp19_ = FALSE;
			ValaSymbol* _tmp20_;
			ValaScope* _tmp22_;
			ValaSymbol* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			ValaSymbol* _tmp26_;
			ValaScope* _tmp27_;
			ValaScope* _tmp28_;
			ValaScope* _tmp29_;
			ValaScope* _tmp30_;
			_tmp20_ = sym;
			if (_tmp20_ == NULL) {
				ValaScope* _tmp21_;
				_tmp21_ = parent_scope;
				_tmp19_ = _tmp21_ != NULL;
			} else {
				_tmp19_ = FALSE;
			}
			if (!_tmp19_) {
				break;
			}
			_tmp22_ = parent_scope;
			_tmp23_ = global_symbol;
			_tmp24_ = vala_symbol_get_name (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_scope_lookup (_tmp22_, _tmp25_);
			_vala_code_node_unref0 (sym);
			sym = _tmp26_;
			_tmp27_ = parent_scope;
			_tmp28_ = vala_scope_get_parent_scope (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = _vala_scope_ref0 (_tmp29_);
			_vala_scope_unref0 (parent_scope);
			parent_scope = _tmp30_;
		}
		_tmp32_ = sym;
		if (_tmp32_ != NULL) {
			ValaSymbol* _tmp33_;
			ValaSymbol* _tmp34_;
			_tmp33_ = global_symbol;
			_tmp34_ = sym;
			_tmp31_ = _tmp33_ != _tmp34_;
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			ValaTypeSymbol* _tmp35_;
			ValaTypeSymbol* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			_tmp35_ = vala_data_type_get_type_symbol (self);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strconcat ("global::", _tmp38_, NULL);
			_g_free0 (s);
			s = _tmp39_;
			_g_free0 (_tmp38_);
		} else {
			ValaTypeSymbol* _tmp40_;
			ValaTypeSymbol* _tmp41_;
			gchar* _tmp42_;
			_tmp40_ = vala_data_type_get_type_symbol (self);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp41_);
			_g_free0 (s);
			s = _tmp42_;
		}
		_vala_scope_unref0 (parent_scope);
		_vala_code_node_unref0 (sym);
		_vala_code_node_unref0 (global_symbol);
	} else {
		gchar* _tmp43_;
		_tmp43_ = g_strdup ("null");
		_g_free0 (s);
		s = _tmp43_;
	}
	_tmp44_ = vala_data_type_get_type_arguments (self);
	_tmp45_ = _vala_iterable_ref0 (_tmp44_);
	type_args = _tmp45_;
	_tmp46_ = type_args;
	_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
	_tmp48_ = _tmp47_;
	if (_tmp48_ > 0) {
		const gchar* _tmp49_;
		gchar* _tmp50_;
		gboolean first = FALSE;
		const gchar* _tmp68_;
		gchar* _tmp69_;
		_tmp49_ = s;
		_tmp50_ = g_strconcat (_tmp49_, "<", NULL);
		_g_free0 (s);
		s = _tmp50_;
		first = TRUE;
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp51_;
			ValaList* _tmp52_;
			gint _type_arg_size = 0;
			ValaList* _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			gint _type_arg_index = 0;
			_tmp51_ = type_args;
			_tmp52_ = _vala_iterable_ref0 (_tmp51_);
			_type_arg_list = _tmp52_;
			_tmp53_ = _type_arg_list;
			_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
			_tmp55_ = _tmp54_;
			_type_arg_size = _tmp55_;
			_type_arg_index = -1;
			while (TRUE) {
				ValaDataType* type_arg = NULL;
				ValaList* _tmp56_;
				gpointer _tmp57_;
				ValaDataType* _tmp60_;
				const gchar* _tmp63_;
				ValaDataType* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				_type_arg_index = _type_arg_index + 1;
				if (!(_type_arg_index < _type_arg_size)) {
					break;
				}
				_tmp56_ = _type_arg_list;
				_tmp57_ = vala_list_get (_tmp56_, _type_arg_index);
				type_arg = (ValaDataType*) _tmp57_;
				if (!first) {
					const gchar* _tmp58_;
					gchar* _tmp59_;
					_tmp58_ = s;
					_tmp59_ = g_strconcat (_tmp58_, ",", NULL);
					_g_free0 (s);
					s = _tmp59_;
				} else {
					first = FALSE;
				}
				_tmp60_ = type_arg;
				if (vala_data_type_is_weak (_tmp60_)) {
					const gchar* _tmp61_;
					gchar* _tmp62_;
					_tmp61_ = s;
					_tmp62_ = g_strconcat (_tmp61_, "weak ", NULL);
					_g_free0 (s);
					s = _tmp62_;
				}
				_tmp63_ = s;
				_tmp64_ = type_arg;
				_tmp65_ = vala_data_type_to_qualified_string (_tmp64_, scope);
				_tmp66_ = _tmp65_;
				_tmp67_ = g_strconcat (_tmp63_, _tmp66_, NULL);
				_g_free0 (s);
				s = _tmp67_;
				_g_free0 (_tmp66_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		_tmp68_ = s;
		_tmp69_ = g_strconcat (_tmp68_, ">", NULL);
		_g_free0 (s);
		s = _tmp69_;
	}
	_tmp70_ = self->priv->_nullable;
	if (_tmp70_) {
		const gchar* _tmp71_;
		gchar* _tmp72_;
		_tmp71_ = s;
		_tmp72_ = g_strconcat (_tmp71_, "?", NULL);
		_g_free0 (s);
		s = _tmp72_;
	}
	result = s;
	_vala_iterable_unref0 (type_args);
	return result;
}

gchar*
vala_data_type_to_qualified_string (ValaDataType* self,
                                    ValaScope* scope)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->to_qualified_string (self, scope);
}

/**
 * Creates a shallow copy of this type reference.
 *
 * @return copy of this type reference
 */
static ValaDataType*
vala_data_type_real_copy (ValaDataType* self)
{
	g_critical ("Type `%s' does not implement abstract method `vala_data_type_copy'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

ValaDataType*
vala_data_type_copy (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->copy (self);
}

/**
 * Checks two type references for equality. May only be used with
 * resolved type references.
 *
 * @param type2 a type reference
 * @return      true if this type reference is equal to type2, false
 *              otherwise
 */
static gboolean
vala_data_type_real_equals (ValaDataType* self,
                            ValaDataType* type2)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaTypeSymbol* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	ValaTypeSymbol* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp12_;
	gboolean _tmp13_;
	ValaList* type_args = NULL;
	ValaList* _tmp14_;
	ValaList* _tmp15_;
	ValaList* type2_args = NULL;
	ValaList* _tmp16_;
	ValaList* _tmp17_;
	ValaList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	ValaList* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gboolean result = FALSE;
	g_return_val_if_fail (type2 != NULL, FALSE);
	if (vala_data_type_is_disposable (type2) != vala_data_type_is_disposable (self)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = type2->priv->_nullable;
	_tmp1_ = self->priv->_nullable;
	if (_tmp0_ != _tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_data_type_get_type_symbol (type2);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_data_type_get_type_symbol (self);
	_tmp5_ = _tmp4_;
	if (_tmp3_ != _tmp5_) {
		result = FALSE;
		return result;
	}
	if (VALA_IS_GENERIC_TYPE (type2)) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = VALA_IS_GENERIC_TYPE (self);
	}
	if (_tmp6_) {
		gboolean _tmp7_ = FALSE;
		ValaTypeParameter* _tmp8_;
		ValaTypeParameter* _tmp9_;
		ValaTypeParameter* _tmp10_;
		ValaTypeParameter* _tmp11_;
		if (!VALA_IS_GENERIC_TYPE (type2)) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = !VALA_IS_GENERIC_TYPE (self);
		}
		if (_tmp7_) {
			result = FALSE;
			return result;
		}
		_tmp8_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (type2, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
		_tmp11_ = _tmp10_;
		if (!vala_typeparameter_equals (_tmp9_, _tmp11_)) {
			result = FALSE;
			return result;
		}
	}
	_tmp12_ = type2->priv->_floating_reference;
	_tmp13_ = self->priv->_floating_reference;
	if (_tmp12_ != _tmp13_) {
		result = FALSE;
		return result;
	}
	_tmp14_ = vala_data_type_get_type_arguments (self);
	_tmp15_ = _vala_iterable_ref0 (_tmp14_);
	type_args = _tmp15_;
	_tmp16_ = vala_data_type_get_type_arguments (type2);
	_tmp17_ = _vala_iterable_ref0 (_tmp16_);
	type2_args = _tmp17_;
	_tmp18_ = type2_args;
	_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = type_args;
	_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp20_ != _tmp23_) {
		result = FALSE;
		_vala_iterable_unref0 (type2_args);
		_vala_iterable_unref0 (type_args);
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				ValaList* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				ValaList* _tmp29_;
				gpointer _tmp30_;
				ValaDataType* _tmp31_;
				ValaList* _tmp32_;
				gpointer _tmp33_;
				ValaDataType* _tmp34_;
				gboolean _tmp35_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				_tmp26_ = type_args;
				_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
				_tmp28_ = _tmp27_;
				if (!(i < _tmp28_)) {
					break;
				}
				_tmp29_ = type2_args;
				_tmp30_ = vala_list_get (_tmp29_, i);
				_tmp31_ = (ValaDataType*) _tmp30_;
				_tmp32_ = type_args;
				_tmp33_ = vala_list_get (_tmp32_, i);
				_tmp34_ = (ValaDataType*) _tmp33_;
				_tmp35_ = !vala_data_type_equals (_tmp31_, _tmp34_);
				_vala_code_node_unref0 (_tmp34_);
				_vala_code_node_unref0 (_tmp31_);
				if (_tmp35_) {
					result = FALSE;
					_vala_iterable_unref0 (type2_args);
					_vala_iterable_unref0 (type_args);
					return result;
				}
			}
		}
	}
	result = TRUE;
	_vala_iterable_unref0 (type2_args);
	_vala_iterable_unref0 (type_args);
	return result;
}

gboolean
vala_data_type_equals (ValaDataType* self,
                       ValaDataType* type2)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->equals (self, type2);
}

/**
 * Checks whether this type reference is at least as strict as the
 * specified type reference type2.
 *
 * @param type2 a type reference
 * @return      true if this type reference is stricter or equal
 */
static gboolean
vala_data_type_real_stricter (ValaDataType* self,
                              ValaDataType* type2)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_ = FALSE;
	ValaTypeSymbol* _tmp4_;
	ValaTypeSymbol* _tmp5_;
	ValaTypeSymbol* _tmp6_;
	ValaTypeSymbol* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean result = FALSE;
	g_return_val_if_fail (type2 != NULL, FALSE);
	if (vala_data_type_is_disposable (type2) != vala_data_type_is_disposable (self)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = type2->priv->_nullable;
	if (!_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_nullable;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (VALA_IS_GENERIC_TYPE (self)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = VALA_IS_GENERIC_TYPE (type2);
	}
	if (_tmp3_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = vala_data_type_get_type_symbol (type2);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_data_type_get_type_symbol (self);
	_tmp7_ = _tmp6_;
	if (_tmp5_ != _tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = type2->priv->_floating_reference;
	_tmp9_ = self->priv->_floating_reference;
	if (_tmp8_ != _tmp9_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

gboolean
vala_data_type_stricter (ValaDataType* self,
                         ValaDataType* type2)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->stricter (self, type2);
}

static void
vala_data_type_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaDataType * self;
	ValaList* _tmp0_;
	self = (ValaDataType*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = self->priv->type_argument_list;
	if (_tmp0_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					ValaList* _tmp3_;
					gint _tmp4_;
					gint _tmp5_;
					ValaList* _tmp6_;
					gpointer _tmp7_;
					ValaDataType* _tmp8_;
					gboolean _tmp9_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = self->priv->type_argument_list;
					_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
					_tmp5_ = _tmp4_;
					if (!(i < _tmp5_)) {
						break;
					}
					_tmp6_ = self->priv->type_argument_list;
					_tmp7_ = vala_list_get (_tmp6_, i);
					_tmp8_ = (ValaDataType*) _tmp7_;
					_tmp9_ = _tmp8_ == old_type;
					_vala_code_node_unref0 (_tmp8_);
					if (_tmp9_) {
						ValaList* _tmp10_;
						_tmp10_ = self->priv->type_argument_list;
						vala_list_set (_tmp10_, i, new_type);
						return;
					}
				}
			}
		}
	}
}

static gboolean
vala_data_type_real_compatible (ValaDataType* self,
                                ValaDataType* target_type)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaCodeContext* _tmp2_;
	ValaCodeContext* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp9_ = FALSE;
	ValaCodeContext* _tmp10_;
	ValaCodeContext* _tmp11_;
	ValaProfile _tmp12_;
	ValaProfile _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp45_ = FALSE;
	ValaTypeSymbol* _tmp46_;
	ValaTypeSymbol* _tmp47_;
	ValaList* type_args = NULL;
	ValaList* _tmp52_;
	ValaList* _tmp53_;
	ValaList* target_type_args = NULL;
	ValaList* _tmp54_;
	ValaList* _tmp55_;
	ValaList* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	ValaList* _tmp59_;
	gint _tmp60_;
	gint _tmp61_;
	gboolean _tmp75_ = FALSE;
	gboolean _tmp76_ = FALSE;
	ValaTypeSymbol* _tmp77_;
	ValaTypeSymbol* _tmp78_;
	gboolean _tmp109_ = FALSE;
	ValaTypeSymbol* _tmp110_;
	ValaTypeSymbol* _tmp111_;
	gboolean result = FALSE;
	g_return_val_if_fail (target_type != NULL, FALSE);
	_tmp2_ = vala_code_context_get ();
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_code_context_get_experimental_non_null (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_vala_code_context_unref0 (_tmp3_);
	if (_tmp6_) {
		gboolean _tmp7_;
		_tmp7_ = self->priv->_nullable;
		_tmp1_ = _tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp8_;
		_tmp8_ = target_type->priv->_nullable;
		_tmp0_ = !_tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp10_ = vala_code_context_get ();
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_code_context_get_profile (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_ == VALA_PROFILE_GOBJECT;
	_vala_code_context_unref0 (_tmp11_);
	if (_tmp14_) {
		ValaTypeSymbol* _tmp15_;
		ValaTypeSymbol* _tmp16_;
		_tmp15_ = vala_data_type_get_type_symbol (target_type);
		_tmp16_ = _tmp15_;
		_tmp9_ = _tmp16_ != NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ValaTypeSymbol* _tmp17_;
		ValaTypeSymbol* _tmp18_;
		ValaCodeContext* _tmp19_;
		ValaCodeContext* _tmp20_;
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaStructValueType* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		gboolean _tmp26_;
		ValaTypeSymbol* _tmp27_;
		ValaTypeSymbol* _tmp28_;
		ValaCodeContext* _tmp29_;
		ValaCodeContext* _tmp30_;
		ValaSemanticAnalyzer* _tmp31_;
		ValaSemanticAnalyzer* _tmp32_;
		ValaObjectType* _tmp33_;
		ValaTypeSymbol* _tmp34_;
		ValaTypeSymbol* _tmp35_;
		gboolean _tmp36_;
		_tmp17_ = vala_data_type_get_type_symbol (target_type);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_context_get ();
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_context_get_analyzer (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->gvalue_type;
		_tmp24_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_typesymbol_is_subtype_of (_tmp18_, _tmp25_);
		_vala_code_context_unref0 (_tmp20_);
		if (_tmp26_) {
			result = TRUE;
			return result;
		}
		_tmp27_ = vala_data_type_get_type_symbol (target_type);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_code_context_get ();
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_code_context_get_analyzer (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = _tmp32_->gvariant_type;
		_tmp34_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_typesymbol_is_subtype_of (_tmp28_, _tmp35_);
		_vala_code_context_unref0 (_tmp30_);
		if (_tmp36_) {
			result = TRUE;
			return result;
		}
	}
	if (VALA_IS_POINTER_TYPE (target_type)) {
		gboolean _tmp37_ = FALSE;
		if (VALA_IS_GENERIC_TYPE (self)) {
			_tmp37_ = TRUE;
		} else {
			gboolean _tmp38_ = FALSE;
			ValaTypeSymbol* _tmp39_;
			ValaTypeSymbol* _tmp40_;
			_tmp39_ = vala_data_type_get_type_symbol (self);
			_tmp40_ = _tmp39_;
			if (_tmp40_ != NULL) {
				gboolean _tmp41_ = FALSE;
				ValaTypeSymbol* _tmp42_;
				ValaTypeSymbol* _tmp43_;
				_tmp42_ = vala_data_type_get_type_symbol (self);
				_tmp43_ = _tmp42_;
				if (vala_typesymbol_is_reference_type (_tmp43_)) {
					_tmp41_ = TRUE;
				} else {
					_tmp41_ = VALA_IS_DELEGATE_TYPE (self);
				}
				_tmp38_ = _tmp41_;
			} else {
				_tmp38_ = FALSE;
			}
			_tmp37_ = _tmp38_;
		}
		if (_tmp37_) {
			result = TRUE;
			return result;
		}
		result = FALSE;
		return result;
	}
	if (VALA_IS_GENERIC_TYPE (target_type)) {
		result = TRUE;
		return result;
	}
	if (VALA_IS_ARRAY_TYPE (self) != VALA_IS_ARRAY_TYPE (target_type)) {
		result = FALSE;
		return result;
	}
	_tmp46_ = vala_data_type_get_type_symbol (self);
	_tmp47_ = _tmp46_;
	if (VALA_IS_ENUM (_tmp47_)) {
		ValaTypeSymbol* _tmp48_;
		ValaTypeSymbol* _tmp49_;
		_tmp48_ = vala_data_type_get_type_symbol (target_type);
		_tmp49_ = _tmp48_;
		_tmp45_ = VALA_IS_STRUCT (_tmp49_);
	} else {
		_tmp45_ = FALSE;
	}
	if (_tmp45_) {
		ValaTypeSymbol* _tmp50_;
		ValaTypeSymbol* _tmp51_;
		_tmp50_ = vala_data_type_get_type_symbol (target_type);
		_tmp51_ = _tmp50_;
		_tmp44_ = vala_struct_is_integer_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, VALA_TYPE_STRUCT, ValaStruct));
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		result = TRUE;
		return result;
	}
	_tmp52_ = vala_data_type_get_type_arguments (self);
	_tmp53_ = _vala_iterable_ref0 (_tmp52_);
	type_args = _tmp53_;
	_tmp54_ = vala_data_type_get_type_arguments (target_type);
	_tmp55_ = _vala_iterable_ref0 (_tmp54_);
	target_type_args = _tmp55_;
	_tmp56_ = type_args;
	_tmp57_ = vala_collection_get_size ((ValaCollection*) _tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = target_type_args;
	_tmp60_ = vala_collection_get_size ((ValaCollection*) _tmp59_);
	_tmp61_ = _tmp60_;
	if (_tmp58_ == _tmp61_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp62_ = FALSE;
				_tmp62_ = TRUE;
				while (TRUE) {
					ValaList* _tmp64_;
					gint _tmp65_;
					gint _tmp66_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp67_;
					gpointer _tmp68_;
					ValaDataType* target_type_arg = NULL;
					ValaList* _tmp69_;
					gpointer _tmp70_;
					gboolean _tmp71_ = FALSE;
					ValaDataType* _tmp72_;
					if (!_tmp62_) {
						gint _tmp63_;
						_tmp63_ = i;
						i = _tmp63_ + 1;
					}
					_tmp62_ = FALSE;
					_tmp64_ = type_args;
					_tmp65_ = vala_collection_get_size ((ValaCollection*) _tmp64_);
					_tmp66_ = _tmp65_;
					if (!(i < _tmp66_)) {
						break;
					}
					_tmp67_ = type_args;
					_tmp68_ = vala_list_get (_tmp67_, i);
					type_arg = (ValaDataType*) _tmp68_;
					_tmp69_ = target_type_args;
					_tmp70_ = vala_list_get (_tmp69_, i);
					target_type_arg = (ValaDataType*) _tmp70_;
					_tmp72_ = type_arg;
					if (!vala_data_type_is_non_null_simple_type (_tmp72_)) {
						ValaDataType* _tmp73_;
						ValaDataType* _tmp74_;
						_tmp73_ = type_arg;
						_tmp74_ = target_type_arg;
						_tmp71_ = vala_data_type_is_weak (_tmp73_) != vala_data_type_is_weak (_tmp74_);
					} else {
						_tmp71_ = FALSE;
					}
					if (_tmp71_) {
						result = FALSE;
						_vala_code_node_unref0 (target_type_arg);
						_vala_code_node_unref0 (type_arg);
						_vala_iterable_unref0 (target_type_args);
						_vala_iterable_unref0 (type_args);
						return result;
					}
					_vala_code_node_unref0 (target_type_arg);
					_vala_code_node_unref0 (type_arg);
				}
			}
		}
	}
	_tmp77_ = vala_data_type_get_type_symbol (self);
	_tmp78_ = _tmp77_;
	if (_tmp78_ != NULL) {
		ValaTypeSymbol* _tmp79_;
		ValaTypeSymbol* _tmp80_;
		_tmp79_ = vala_data_type_get_type_symbol (target_type);
		_tmp80_ = _tmp79_;
		_tmp76_ = _tmp80_ != NULL;
	} else {
		_tmp76_ = FALSE;
	}
	if (_tmp76_) {
		ValaTypeSymbol* _tmp81_;
		ValaTypeSymbol* _tmp82_;
		ValaTypeSymbol* _tmp83_;
		ValaTypeSymbol* _tmp84_;
		_tmp81_ = vala_data_type_get_type_symbol (self);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_data_type_get_type_symbol (target_type);
		_tmp84_ = _tmp83_;
		_tmp75_ = vala_typesymbol_is_subtype_of (_tmp82_, _tmp84_);
	} else {
		_tmp75_ = FALSE;
	}
	if (_tmp75_) {
		ValaDataType* base_type = NULL;
		ValaTypeSymbol* _tmp85_;
		ValaTypeSymbol* _tmp86_;
		ValaDataType* _tmp87_;
		ValaList* base_type_args = NULL;
		ValaDataType* _tmp88_;
		ValaList* _tmp89_;
		ValaList* _tmp90_;
		ValaList* _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		ValaList* _tmp94_;
		gint _tmp95_;
		gint _tmp96_;
		_tmp85_ = vala_data_type_get_type_symbol (target_type);
		_tmp86_ = _tmp85_;
		_tmp87_ = vala_semantic_analyzer_get_instance_base_type_for_member (self, _tmp86_, (ValaCodeNode*) self);
		base_type = _tmp87_;
		_tmp88_ = base_type;
		_tmp89_ = vala_data_type_get_type_arguments (_tmp88_);
		_tmp90_ = _vala_iterable_ref0 (_tmp89_);
		base_type_args = _tmp90_;
		_tmp91_ = base_type_args;
		_tmp92_ = vala_collection_get_size ((ValaCollection*) _tmp91_);
		_tmp93_ = _tmp92_;
		_tmp94_ = target_type_args;
		_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
		_tmp96_ = _tmp95_;
		if (_tmp93_ == _tmp96_) {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp97_ = FALSE;
					_tmp97_ = TRUE;
					while (TRUE) {
						ValaList* _tmp99_;
						gint _tmp100_;
						gint _tmp101_;
						ValaList* _tmp102_;
						gpointer _tmp103_;
						ValaDataType* _tmp104_;
						ValaList* _tmp105_;
						gpointer _tmp106_;
						ValaDataType* _tmp107_;
						gboolean _tmp108_;
						if (!_tmp97_) {
							gint _tmp98_;
							_tmp98_ = i;
							i = _tmp98_ + 1;
						}
						_tmp97_ = FALSE;
						_tmp99_ = base_type_args;
						_tmp100_ = vala_collection_get_size ((ValaCollection*) _tmp99_);
						_tmp101_ = _tmp100_;
						if (!(i < _tmp101_)) {
							break;
						}
						_tmp102_ = base_type_args;
						_tmp103_ = vala_list_get (_tmp102_, i);
						_tmp104_ = (ValaDataType*) _tmp103_;
						_tmp105_ = target_type_args;
						_tmp106_ = vala_list_get (_tmp105_, i);
						_tmp107_ = (ValaDataType*) _tmp106_;
						_tmp108_ = !vala_data_type_compatible (_tmp104_, _tmp107_);
						_vala_code_node_unref0 (_tmp107_);
						_vala_code_node_unref0 (_tmp104_);
						if (_tmp108_) {
							result = FALSE;
							_vala_iterable_unref0 (base_type_args);
							_vala_code_node_unref0 (base_type);
							_vala_iterable_unref0 (target_type_args);
							_vala_iterable_unref0 (type_args);
							return result;
						}
					}
				}
			}
		}
		result = TRUE;
		_vala_iterable_unref0 (base_type_args);
		_vala_code_node_unref0 (base_type);
		_vala_iterable_unref0 (target_type_args);
		_vala_iterable_unref0 (type_args);
		return result;
	}
	_tmp110_ = vala_data_type_get_type_symbol (self);
	_tmp111_ = _tmp110_;
	if (VALA_IS_STRUCT (_tmp111_)) {
		ValaTypeSymbol* _tmp112_;
		ValaTypeSymbol* _tmp113_;
		_tmp112_ = vala_data_type_get_type_symbol (target_type);
		_tmp113_ = _tmp112_;
		_tmp109_ = VALA_IS_STRUCT (_tmp113_);
	} else {
		_tmp109_ = FALSE;
	}
	if (_tmp109_) {
		ValaStruct* expr_struct = NULL;
		ValaTypeSymbol* _tmp114_;
		ValaTypeSymbol* _tmp115_;
		ValaStruct* expect_struct = NULL;
		ValaTypeSymbol* _tmp116_;
		ValaTypeSymbol* _tmp117_;
		gboolean _tmp118_ = FALSE;
		ValaStruct* _tmp119_;
		gboolean _tmp121_ = FALSE;
		gboolean _tmp122_ = FALSE;
		ValaStruct* _tmp123_;
		gboolean _tmp134_ = FALSE;
		ValaStruct* _tmp135_;
		ValaStruct* _tmp137_;
		ValaStruct* _tmp138_;
		_tmp114_ = vala_data_type_get_type_symbol (self);
		_tmp115_ = _tmp114_;
		expr_struct = G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp116_ = vala_data_type_get_type_symbol (target_type);
		_tmp117_ = _tmp116_;
		expect_struct = G_TYPE_CHECK_INSTANCE_CAST (_tmp117_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp119_ = expr_struct;
		if (vala_struct_is_integer_type (_tmp119_)) {
			ValaStruct* _tmp120_;
			_tmp120_ = expect_struct;
			_tmp118_ = vala_struct_is_floating_type (_tmp120_);
		} else {
			_tmp118_ = FALSE;
		}
		if (_tmp118_) {
			result = TRUE;
			_vala_iterable_unref0 (target_type_args);
			_vala_iterable_unref0 (type_args);
			return result;
		}
		_tmp123_ = expr_struct;
		if (vala_struct_is_integer_type (_tmp123_)) {
			ValaStruct* _tmp124_;
			_tmp124_ = expect_struct;
			_tmp122_ = vala_struct_is_integer_type (_tmp124_);
		} else {
			_tmp122_ = FALSE;
		}
		if (_tmp122_) {
			_tmp121_ = TRUE;
		} else {
			gboolean _tmp125_ = FALSE;
			ValaStruct* _tmp126_;
			_tmp126_ = expr_struct;
			if (vala_struct_is_floating_type (_tmp126_)) {
				ValaStruct* _tmp127_;
				_tmp127_ = expect_struct;
				_tmp125_ = vala_struct_is_floating_type (_tmp127_);
			} else {
				_tmp125_ = FALSE;
			}
			_tmp121_ = _tmp125_;
		}
		if (_tmp121_) {
			ValaStruct* _tmp128_;
			gint _tmp129_;
			gint _tmp130_;
			ValaStruct* _tmp131_;
			gint _tmp132_;
			gint _tmp133_;
			_tmp128_ = expr_struct;
			_tmp129_ = vala_struct_get_rank (_tmp128_);
			_tmp130_ = _tmp129_;
			_tmp131_ = expect_struct;
			_tmp132_ = vala_struct_get_rank (_tmp131_);
			_tmp133_ = _tmp132_;
			if (_tmp130_ <= _tmp133_) {
				result = TRUE;
				_vala_iterable_unref0 (target_type_args);
				_vala_iterable_unref0 (type_args);
				return result;
			}
		}
		_tmp135_ = expr_struct;
		if (vala_struct_is_boolean_type (_tmp135_)) {
			ValaStruct* _tmp136_;
			_tmp136_ = expect_struct;
			_tmp134_ = vala_struct_is_boolean_type (_tmp136_);
		} else {
			_tmp134_ = FALSE;
		}
		if (_tmp134_) {
			result = TRUE;
			_vala_iterable_unref0 (target_type_args);
			_vala_iterable_unref0 (type_args);
			return result;
		}
		_tmp137_ = expect_struct;
		_tmp138_ = expr_struct;
		if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp137_, (ValaTypeSymbol*) _tmp138_)) {
			result = TRUE;
			_vala_iterable_unref0 (target_type_args);
			_vala_iterable_unref0 (type_args);
			return result;
		}
	}
	result = FALSE;
	_vala_iterable_unref0 (target_type_args);
	_vala_iterable_unref0 (type_args);
	return result;
}

gboolean
vala_data_type_compatible (ValaDataType* self,
                           ValaDataType* target_type)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->compatible (self, target_type);
}

/**
 * Returns whether instances of this type are invokable.
 *
 * @return true if invokable, false otherwise
 */
static gboolean
vala_data_type_real_is_invokable (ValaDataType* self)
{
	gboolean result = FALSE;
	result = FALSE;
	return result;
}

gboolean
vala_data_type_is_invokable (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_invokable (self);
}

/**
 * Returns the return type of this invokable.
 *
 * @return return type
 */
static ValaDataType*
vala_data_type_real_get_return_type (ValaDataType* self)
{
	ValaDataType* result = NULL;
	result = NULL;
	return result;
}

ValaDataType*
vala_data_type_get_return_type (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_return_type (self);
}

/**
 * Returns the list of invocation parameters.
 *
 * @return parameter list
 */
static ValaList*
vala_data_type_real_get_parameters (ValaDataType* self)
{
	ValaList* result = NULL;
	result = NULL;
	return result;
}

ValaList*
vala_data_type_get_parameters (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_parameters (self);
}

static gboolean
vala_data_type_real_is_reference_type_or_type_parameter (ValaDataType* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaTypeSymbol* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	gboolean result = FALSE;
	_tmp2_ = vala_data_type_get_type_symbol (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaTypeSymbol* _tmp4_;
		ValaTypeSymbol* _tmp5_;
		_tmp4_ = vala_data_type_get_type_symbol (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_typesymbol_is_reference_type (_tmp5_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_GENERIC_TYPE (self);
	}
	result = _tmp0_;
	return result;
}

gboolean
vala_data_type_is_reference_type_or_type_parameter (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_reference_type_or_type_parameter (self);
}

static gboolean
vala_data_type_real_is_accessible (ValaDataType* self,
                                   ValaSymbol* sym)
{
	ValaTypeSymbol* _tmp8_;
	ValaTypeSymbol* _tmp9_;
	gboolean result = FALSE;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_arg_index = 0;
		_tmp0_ = vala_data_type_get_type_arguments (self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_arg_list = _tmp1_;
		_tmp2_ = _type_arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_arg_size = _tmp4_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp5_ = _type_arg_list;
			_tmp6_ = vala_list_get (_tmp5_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp6_;
			_tmp7_ = type_arg;
			if (!vala_data_type_is_accessible (_tmp7_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (type_arg);
				_vala_iterable_unref0 (_type_arg_list);
				return result;
			}
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	_tmp8_ = vala_data_type_get_type_symbol (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaTypeSymbol* _tmp10_;
		ValaTypeSymbol* _tmp11_;
		_tmp10_ = vala_data_type_get_type_symbol (self);
		_tmp11_ = _tmp10_;
		result = vala_symbol_is_accessible ((ValaSymbol*) _tmp11_, sym);
		return result;
	}
	result = TRUE;
	return result;
}

gboolean
vala_data_type_is_accessible (ValaDataType* self,
                              ValaSymbol* sym)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_accessible (self, sym);
}

static ValaSymbol*
vala_data_type_real_get_member (ValaDataType* self,
                                const gchar* member_name)
{
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaSymbol* result = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	_tmp0_ = vala_data_type_get_type_symbol (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaTypeSymbol* _tmp2_;
		ValaTypeSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp2_ = vala_data_type_get_type_symbol (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp3_, member_name);
		result = _tmp4_;
		return result;
	}
	result = NULL;
	return result;
}

ValaSymbol*
vala_data_type_get_member (ValaDataType* self,
                           const gchar* member_name)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_member (self, member_name);
}

static ValaSymbol*
vala_data_type_real_get_pointer_member (ValaDataType* self,
                                        const gchar* member_name)
{
	ValaSymbol* result = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	result = NULL;
	return result;
}

ValaSymbol*
vala_data_type_get_pointer_member (ValaDataType* self,
                                   const gchar* member_name)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_pointer_member (self, member_name);
}

/**
 * Checks whether this data type references a real struct. A real struct
 * is a struct which is not a simple (fundamental) type.
 */
static gboolean
vala_data_type_real_is_real_struct_type (ValaDataType* self)
{
	ValaStruct* s = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaStruct* _tmp3_;
	gboolean result = FALSE;
	_tmp0_ = vala_data_type_get_type_symbol (self);
	_tmp1_ = _tmp0_;
	s = VALA_IS_STRUCT (_tmp1_) ? ((ValaStruct*) _tmp1_) : NULL;
	_tmp3_ = s;
	if (_tmp3_ != NULL) {
		ValaStruct* _tmp4_;
		_tmp4_ = s;
		_tmp2_ = !vala_struct_is_simple_type (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
vala_data_type_is_real_struct_type (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_real_struct_type (self);
}

gboolean
vala_data_type_is_real_non_null_struct_type (ValaDataType* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_data_type_is_real_struct_type (self)) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->_nullable;
		_tmp0_ = !_tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
vala_data_type_is_non_null_simple_type (ValaDataType* self)
{
	ValaStruct* s = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaStruct* _tmp3_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_data_type_get_type_symbol (self);
	_tmp1_ = _tmp0_;
	s = VALA_IS_STRUCT (_tmp1_) ? ((ValaStruct*) _tmp1_) : NULL;
	_tmp3_ = s;
	if (_tmp3_ != NULL) {
		ValaStruct* _tmp4_;
		_tmp4_ = s;
		_tmp2_ = vala_struct_is_simple_type (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp5_;
		_tmp5_ = self->priv->_nullable;
		result = !_tmp5_;
		return result;
	}
	result = FALSE;
	return result;
}

/**
 * Returns whether the value needs to be disposed, i.e. whether
 * allocated memory or other resources need to be released when
 * the value is no longer needed.
 */
static gboolean
vala_data_type_real_is_disposable (ValaDataType* self)
{
	gboolean _tmp0_;
	gboolean result = FALSE;
	_tmp0_ = self->priv->_value_owned;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	if (vala_data_type_is_reference_type_or_type_parameter (self)) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
vala_data_type_is_disposable (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_disposable (self);
}

static ValaDataType*
vala_data_type_real_get_actual_type (ValaDataType* self,
                                     ValaDataType* derived_instance_type,
                                     ValaList* method_type_arguments,
                                     ValaCodeNode* node_reference)
{
	ValaDataType* _result_ = NULL;
	ValaDataType* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaDataType* _tmp2_;
	ValaList* _tmp3_;
	ValaDataType* result = NULL;
	_tmp0_ = vala_data_type_copy (self);
	_result_ = _tmp0_;
	if (derived_instance_type == NULL) {
		_tmp1_ = method_type_arguments == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = _result_;
		return result;
	}
	_tmp2_ = _result_;
	_tmp3_ = _tmp2_->priv->type_argument_list;
	if (_tmp3_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					ValaDataType* _tmp6_;
					ValaList* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					ValaDataType* _tmp10_;
					ValaList* _tmp11_;
					ValaDataType* _tmp12_;
					ValaList* _tmp13_;
					gpointer _tmp14_;
					ValaDataType* _tmp15_;
					ValaDataType* _tmp16_;
					ValaDataType* _tmp17_;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					_tmp6_ = _result_;
					_tmp7_ = _tmp6_->priv->type_argument_list;
					_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
					_tmp9_ = _tmp8_;
					if (!(i < _tmp9_)) {
						break;
					}
					_tmp10_ = _result_;
					_tmp11_ = _tmp10_->priv->type_argument_list;
					_tmp12_ = _result_;
					_tmp13_ = _tmp12_->priv->type_argument_list;
					_tmp14_ = vala_list_get (_tmp13_, i);
					_tmp15_ = (ValaDataType*) _tmp14_;
					_tmp16_ = vala_data_type_get_actual_type (_tmp15_, derived_instance_type, method_type_arguments, node_reference);
					_tmp17_ = _tmp16_;
					vala_list_set (_tmp11_, i, _tmp17_);
					_vala_code_node_unref0 (_tmp17_);
					_vala_code_node_unref0 (_tmp15_);
				}
			}
		}
	}
	result = _result_;
	return result;
}

ValaDataType*
vala_data_type_get_actual_type (ValaDataType* self,
                                ValaDataType* derived_instance_type,
                                ValaList* method_type_arguments,
                                ValaCodeNode* node_reference)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_actual_type (self, derived_instance_type, method_type_arguments, node_reference);
}

/**
 * Search for the type parameter in this formal type and match it in
 * value_type.
 */
static ValaDataType*
vala_data_type_real_infer_type_argument (ValaDataType* self,
                                         ValaTypeParameter* type_param,
                                         ValaDataType* value_type)
{
	ValaIterator* value_type_arg_it = NULL;
	ValaList* _tmp0_;
	ValaIterator* _tmp1_;
	ValaDataType* result = NULL;
	g_return_val_if_fail (type_param != NULL, NULL);
	g_return_val_if_fail (value_type != NULL, NULL);
	_tmp0_ = vala_data_type_get_type_arguments (value_type);
	_tmp1_ = vala_iterable_iterator ((ValaIterable*) _tmp0_);
	value_type_arg_it = _tmp1_;
	{
		ValaList* _formal_type_arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _formal_type_arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _formal_type_arg_index = 0;
		_tmp2_ = vala_data_type_get_type_arguments (self);
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_formal_type_arg_list = _tmp3_;
		_tmp4_ = _formal_type_arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_formal_type_arg_size = _tmp6_;
		_formal_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* formal_type_arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaIterator* _tmp9_;
			_formal_type_arg_index = _formal_type_arg_index + 1;
			if (!(_formal_type_arg_index < _formal_type_arg_size)) {
				break;
			}
			_tmp7_ = _formal_type_arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _formal_type_arg_index);
			formal_type_arg = (ValaDataType*) _tmp8_;
			_tmp9_ = value_type_arg_it;
			if (vala_iterator_next (_tmp9_)) {
				ValaDataType* inferred_type = NULL;
				ValaDataType* _tmp10_;
				ValaIterator* _tmp11_;
				gpointer _tmp12_;
				ValaDataType* _tmp13_;
				ValaDataType* _tmp14_;
				ValaDataType* _tmp15_;
				ValaDataType* _tmp16_;
				_tmp10_ = formal_type_arg;
				_tmp11_ = value_type_arg_it;
				_tmp12_ = vala_iterator_get (_tmp11_);
				_tmp13_ = (ValaDataType*) _tmp12_;
				_tmp14_ = vala_data_type_infer_type_argument (_tmp10_, type_param, _tmp13_);
				_tmp15_ = _tmp14_;
				_vala_code_node_unref0 (_tmp13_);
				inferred_type = _tmp15_;
				_tmp16_ = inferred_type;
				if (_tmp16_ != NULL) {
					result = inferred_type;
					_vala_code_node_unref0 (formal_type_arg);
					_vala_iterable_unref0 (_formal_type_arg_list);
					_vala_iterator_unref0 (value_type_arg_it);
					return result;
				}
				_vala_code_node_unref0 (inferred_type);
			}
			_vala_code_node_unref0 (formal_type_arg);
		}
		_vala_iterable_unref0 (_formal_type_arg_list);
	}
	result = NULL;
	_vala_iterator_unref0 (value_type_arg_it);
	return result;
}

ValaDataType*
vala_data_type_infer_type_argument (ValaDataType* self,
                                    ValaTypeParameter* type_param,
                                    ValaDataType* value_type)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->infer_type_argument (self, type_param, value_type);
}

/**
 * Returns a stringified representation used for detailed error output
 *
 * @param override_name used as name if given
 * @return stringified representation
 */
static gchar*
vala_data_type_real_to_prototype_string (ValaDataType* self,
                                         const gchar* override_name)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result = NULL;
	if (vala_data_type_is_weak (self)) {
		_tmp0_ = "unowned ";
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = vala_data_type_to_qualified_string (self, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%s%s", _tmp0_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

gchar*
vala_data_type_to_prototype_string (ValaDataType* self,
                                    const gchar* override_name)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->to_prototype_string (self, override_name);
}

gboolean
vala_data_type_is_weak (ValaDataType* self)
{
	gboolean _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_value_owned;
	if (_tmp0_) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (VALA_IS_VOID_TYPE (self)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = VALA_IS_POINTER_TYPE (self);
		}
		if (_tmp1_) {
			result = FALSE;
			return result;
		} else {
			if (VALA_IS_VALUE_TYPE (self)) {
				gboolean _tmp2_;
				_tmp2_ = self->priv->_nullable;
				if (_tmp2_) {
					result = TRUE;
					return result;
				}
				result = FALSE;
				return result;
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
vala_data_type_get_type_signature (ValaDataType* self,
                                   ValaSymbol* symbol)
{
	ValaArrayType* array_type = NULL;
	ValaArrayType* _tmp2_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (symbol != NULL) {
		gchar* sig = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) symbol, "DBus", "signature", NULL);
		sig = _tmp0_;
		_tmp1_ = sig;
		if (_tmp1_ != NULL) {
			result = sig;
			return result;
		}
		_g_free0 (sig);
	}
	array_type = VALA_IS_ARRAY_TYPE (self) ? ((ValaArrayType*) self) : NULL;
	_tmp2_ = array_type;
	if (_tmp2_ != NULL) {
		gchar* element_type_signature = NULL;
		ValaArrayType* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		ValaArrayType* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp3_ = array_type;
		_tmp4_ = vala_array_type_get_element_type (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_data_type_get_type_signature (_tmp5_, NULL);
		element_type_signature = _tmp6_;
		_tmp7_ = element_type_signature;
		if (_tmp7_ == NULL) {
			result = NULL;
			_g_free0 (element_type_signature);
			return result;
		}
		_tmp8_ = array_type;
		_tmp9_ = vala_array_type_get_rank (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strnfill ((gsize) _tmp10_, 'a');
		_tmp12_ = _tmp11_;
		_tmp13_ = element_type_signature;
		_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp12_);
		result = _tmp15_;
		_g_free0 (element_type_signature);
		return result;
	} else {
		gboolean _tmp16_ = FALSE;
		ValaTypeSymbol* _tmp17_;
		ValaTypeSymbol* _tmp18_;
		_tmp17_ = vala_data_type_get_type_symbol (self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_ENUM (_tmp18_)) {
			ValaTypeSymbol* _tmp19_;
			ValaTypeSymbol* _tmp20_;
			_tmp19_ = vala_data_type_get_type_symbol (self);
			_tmp20_ = _tmp19_;
			_tmp16_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp20_, "DBus", "use_string_marshalling", FALSE);
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("s");
			result = _tmp21_;
			return result;
		} else {
			ValaTypeSymbol* _tmp22_;
			ValaTypeSymbol* _tmp23_;
			_tmp22_ = vala_data_type_get_type_symbol (self);
			_tmp23_ = _tmp22_;
			if (_tmp23_ != NULL) {
				gchar* sig = NULL;
				ValaTypeSymbol* _tmp24_;
				ValaTypeSymbol* _tmp25_;
				gchar* _tmp26_;
				ValaStruct* st = NULL;
				ValaTypeSymbol* _tmp27_;
				ValaTypeSymbol* _tmp28_;
				ValaEnum* en = NULL;
				ValaTypeSymbol* _tmp29_;
				ValaTypeSymbol* _tmp30_;
				gboolean _tmp31_ = FALSE;
				const gchar* _tmp32_;
				ValaList* type_args = NULL;
				ValaList* _tmp66_;
				ValaList* _tmp67_;
				gboolean _tmp68_ = FALSE;
				gboolean _tmp69_ = FALSE;
				const gchar* _tmp70_;
				gboolean _tmp92_ = FALSE;
				const gchar* _tmp93_;
				_tmp24_ = vala_data_type_get_type_symbol (self);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp25_, "CCode", "type_signature", NULL);
				sig = _tmp26_;
				_tmp27_ = vala_data_type_get_type_symbol (self);
				_tmp28_ = _tmp27_;
				st = VALA_IS_STRUCT (_tmp28_) ? ((ValaStruct*) _tmp28_) : NULL;
				_tmp29_ = vala_data_type_get_type_symbol (self);
				_tmp30_ = _tmp29_;
				en = VALA_IS_ENUM (_tmp30_) ? ((ValaEnum*) _tmp30_) : NULL;
				_tmp32_ = sig;
				if (_tmp32_ == NULL) {
					ValaStruct* _tmp33_;
					_tmp33_ = st;
					_tmp31_ = _tmp33_ != NULL;
				} else {
					_tmp31_ = FALSE;
				}
				if (_tmp31_) {
					GString* str = NULL;
					GString* _tmp34_;
					GString* _tmp35_;
					GString* _tmp54_;
					GString* _tmp55_;
					const gchar* _tmp56_;
					gchar* _tmp57_;
					_tmp34_ = g_string_new ("");
					str = _tmp34_;
					_tmp35_ = str;
					g_string_append_c (_tmp35_, '(');
					{
						ValaList* _f_list = NULL;
						ValaStruct* _tmp36_;
						ValaList* _tmp37_;
						ValaList* _tmp38_;
						gint _f_size = 0;
						ValaList* _tmp39_;
						gint _tmp40_;
						gint _tmp41_;
						gint _f_index = 0;
						_tmp36_ = st;
						_tmp37_ = vala_struct_get_fields (_tmp36_);
						_tmp38_ = _vala_iterable_ref0 (_tmp37_);
						_f_list = _tmp38_;
						_tmp39_ = _f_list;
						_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
						_tmp41_ = _tmp40_;
						_f_size = _tmp41_;
						_f_index = -1;
						while (TRUE) {
							ValaField* f = NULL;
							ValaList* _tmp42_;
							gpointer _tmp43_;
							ValaField* _tmp44_;
							ValaMemberBinding _tmp45_;
							ValaMemberBinding _tmp46_;
							_f_index = _f_index + 1;
							if (!(_f_index < _f_size)) {
								break;
							}
							_tmp42_ = _f_list;
							_tmp43_ = vala_list_get (_tmp42_, _f_index);
							f = (ValaField*) _tmp43_;
							_tmp44_ = f;
							_tmp45_ = vala_field_get_binding (_tmp44_);
							_tmp46_ = _tmp45_;
							if (_tmp46_ == VALA_MEMBER_BINDING_INSTANCE) {
								GString* _tmp47_;
								ValaField* _tmp48_;
								ValaDataType* _tmp49_;
								ValaDataType* _tmp50_;
								ValaField* _tmp51_;
								gchar* _tmp52_;
								gchar* _tmp53_;
								_tmp47_ = str;
								_tmp48_ = f;
								_tmp49_ = vala_variable_get_variable_type ((ValaVariable*) _tmp48_);
								_tmp50_ = _tmp49_;
								_tmp51_ = f;
								_tmp52_ = vala_data_type_get_type_signature (_tmp50_, (ValaSymbol*) _tmp51_);
								_tmp53_ = _tmp52_;
								g_string_append (_tmp47_, _tmp53_);
								_g_free0 (_tmp53_);
							}
							_vala_code_node_unref0 (f);
						}
						_vala_iterable_unref0 (_f_list);
					}
					_tmp54_ = str;
					g_string_append_c (_tmp54_, ')');
					_tmp55_ = str;
					_tmp56_ = _tmp55_->str;
					_tmp57_ = g_strdup (_tmp56_);
					_g_free0 (sig);
					sig = _tmp57_;
					_g_string_free0 (str);
				} else {
					gboolean _tmp58_ = FALSE;
					const gchar* _tmp59_;
					_tmp59_ = sig;
					if (_tmp59_ == NULL) {
						ValaEnum* _tmp60_;
						_tmp60_ = en;
						_tmp58_ = _tmp60_ != NULL;
					} else {
						_tmp58_ = FALSE;
					}
					if (_tmp58_) {
						ValaEnum* _tmp61_;
						gboolean _tmp62_;
						gboolean _tmp63_;
						_tmp61_ = en;
						_tmp62_ = vala_enum_get_is_flags (_tmp61_);
						_tmp63_ = _tmp62_;
						if (_tmp63_) {
							gchar* _tmp64_;
							_tmp64_ = g_strdup ("u");
							result = _tmp64_;
							_g_free0 (sig);
							return result;
						} else {
							gchar* _tmp65_;
							_tmp65_ = g_strdup ("i");
							result = _tmp65_;
							_g_free0 (sig);
							return result;
						}
					}
				}
				_tmp66_ = vala_data_type_get_type_arguments (self);
				_tmp67_ = _vala_iterable_ref0 (_tmp66_);
				type_args = _tmp67_;
				_tmp70_ = sig;
				if (_tmp70_ != NULL) {
					const gchar* _tmp71_;
					_tmp71_ = sig;
					_tmp69_ = string_contains (_tmp71_, "%s");
				} else {
					_tmp69_ = FALSE;
				}
				if (_tmp69_) {
					ValaList* _tmp72_;
					gint _tmp73_;
					gint _tmp74_;
					_tmp72_ = type_args;
					_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
					_tmp74_ = _tmp73_;
					_tmp68_ = _tmp74_ > 0;
				} else {
					_tmp68_ = FALSE;
				}
				if (_tmp68_) {
					gchar* element_sig = NULL;
					gchar* _tmp75_;
					const gchar* _tmp89_;
					const gchar* _tmp90_;
					gchar* _tmp91_;
					_tmp75_ = g_strdup ("");
					element_sig = _tmp75_;
					{
						ValaList* _type_arg_list = NULL;
						ValaList* _tmp76_;
						ValaList* _tmp77_;
						gint _type_arg_size = 0;
						ValaList* _tmp78_;
						gint _tmp79_;
						gint _tmp80_;
						gint _type_arg_index = 0;
						_tmp76_ = type_args;
						_tmp77_ = _vala_iterable_ref0 (_tmp76_);
						_type_arg_list = _tmp77_;
						_tmp78_ = _type_arg_list;
						_tmp79_ = vala_collection_get_size ((ValaCollection*) _tmp78_);
						_tmp80_ = _tmp79_;
						_type_arg_size = _tmp80_;
						_type_arg_index = -1;
						while (TRUE) {
							ValaDataType* type_arg = NULL;
							ValaList* _tmp81_;
							gpointer _tmp82_;
							gchar* s = NULL;
							ValaDataType* _tmp83_;
							gchar* _tmp84_;
							const gchar* _tmp85_;
							_type_arg_index = _type_arg_index + 1;
							if (!(_type_arg_index < _type_arg_size)) {
								break;
							}
							_tmp81_ = _type_arg_list;
							_tmp82_ = vala_list_get (_tmp81_, _type_arg_index);
							type_arg = (ValaDataType*) _tmp82_;
							_tmp83_ = type_arg;
							_tmp84_ = vala_data_type_get_type_signature (_tmp83_, NULL);
							s = _tmp84_;
							_tmp85_ = s;
							if (_tmp85_ != NULL) {
								const gchar* _tmp86_;
								const gchar* _tmp87_;
								gchar* _tmp88_;
								_tmp86_ = element_sig;
								_tmp87_ = s;
								_tmp88_ = g_strconcat (_tmp86_, _tmp87_, NULL);
								_g_free0 (element_sig);
								element_sig = _tmp88_;
							}
							_g_free0 (s);
							_vala_code_node_unref0 (type_arg);
						}
						_vala_iterable_unref0 (_type_arg_list);
					}
					_tmp89_ = sig;
					_tmp90_ = element_sig;
					_tmp91_ = string_replace (_tmp89_, "%s", _tmp90_);
					_g_free0 (sig);
					sig = _tmp91_;
					_g_free0 (element_sig);
				}
				_tmp93_ = sig;
				if (_tmp93_ == NULL) {
					gboolean _tmp94_ = FALSE;
					gboolean _tmp95_ = FALSE;
					ValaTypeSymbol* _tmp96_;
					ValaTypeSymbol* _tmp97_;
					gchar* _tmp98_;
					gchar* _tmp99_;
					gboolean _tmp100_;
					_tmp96_ = vala_data_type_get_type_symbol (self);
					_tmp97_ = _tmp96_;
					_tmp98_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp97_);
					_tmp99_ = _tmp98_;
					_tmp100_ = g_strcmp0 (_tmp99_, "GLib.UnixInputStream") == 0;
					_g_free0 (_tmp99_);
					if (_tmp100_) {
						_tmp95_ = TRUE;
					} else {
						ValaTypeSymbol* _tmp101_;
						ValaTypeSymbol* _tmp102_;
						gchar* _tmp103_;
						gchar* _tmp104_;
						_tmp101_ = vala_data_type_get_type_symbol (self);
						_tmp102_ = _tmp101_;
						_tmp103_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp102_);
						_tmp104_ = _tmp103_;
						_tmp95_ = g_strcmp0 (_tmp104_, "GLib.UnixOutputStream") == 0;
						_g_free0 (_tmp104_);
					}
					if (_tmp95_) {
						_tmp94_ = TRUE;
					} else {
						ValaTypeSymbol* _tmp105_;
						ValaTypeSymbol* _tmp106_;
						gchar* _tmp107_;
						gchar* _tmp108_;
						_tmp105_ = vala_data_type_get_type_symbol (self);
						_tmp106_ = _tmp105_;
						_tmp107_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp106_);
						_tmp108_ = _tmp107_;
						_tmp94_ = g_strcmp0 (_tmp108_, "GLib.Socket") == 0;
						_g_free0 (_tmp108_);
					}
					_tmp92_ = _tmp94_;
				} else {
					_tmp92_ = FALSE;
				}
				if (_tmp92_) {
					gchar* _tmp109_;
					_tmp109_ = g_strdup ("h");
					result = _tmp109_;
					_vala_iterable_unref0 (type_args);
					_g_free0 (sig);
					return result;
				}
				result = sig;
				_vala_iterable_unref0 (type_args);
				return result;
			} else {
				result = NULL;
				return result;
			}
		}
	}
}

ValaDataType*
vala_data_type_construct (GType object_type)
{
	ValaDataType* self = NULL;
	self = (ValaDataType*) vala_code_node_construct (object_type);
	return self;
}

static void
vala_data_type_class_init (ValaDataTypeClass * klass,
                           gpointer klass_data)
{
	vala_data_type_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_data_type_finalize;
	g_type_class_adjust_private_offset (klass, &ValaDataType_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_data_type_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_data_type_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_data_type_real_to_string;
	((ValaDataTypeClass *) klass)->to_qualified_string = (gchar* (*) (ValaDataType*, ValaScope*)) vala_data_type_real_to_qualified_string;
	((ValaDataTypeClass *) klass)->copy = (ValaDataType* (*) (ValaDataType*)) vala_data_type_real_copy;
	((ValaDataTypeClass *) klass)->equals = (gboolean (*) (ValaDataType*, ValaDataType*)) vala_data_type_real_equals;
	((ValaDataTypeClass *) klass)->stricter = (gboolean (*) (ValaDataType*, ValaDataType*)) vala_data_type_real_stricter;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_data_type_real_replace_type;
	((ValaDataTypeClass *) klass)->compatible = (gboolean (*) (ValaDataType*, ValaDataType*)) vala_data_type_real_compatible;
	((ValaDataTypeClass *) klass)->is_invokable = (gboolean (*) (ValaDataType*)) vala_data_type_real_is_invokable;
	((ValaDataTypeClass *) klass)->get_return_type = (ValaDataType* (*) (ValaDataType*)) vala_data_type_real_get_return_type;
	((ValaDataTypeClass *) klass)->get_parameters = (ValaList* (*) (ValaDataType*)) vala_data_type_real_get_parameters;
	((ValaDataTypeClass *) klass)->is_reference_type_or_type_parameter = (gboolean (*) (ValaDataType*)) vala_data_type_real_is_reference_type_or_type_parameter;
	((ValaDataTypeClass *) klass)->is_accessible = (gboolean (*) (ValaDataType*, ValaSymbol*)) vala_data_type_real_is_accessible;
	((ValaDataTypeClass *) klass)->get_member = (ValaSymbol* (*) (ValaDataType*, const gchar*)) vala_data_type_real_get_member;
	((ValaDataTypeClass *) klass)->get_pointer_member = (ValaSymbol* (*) (ValaDataType*, const gchar*)) vala_data_type_real_get_pointer_member;
	((ValaDataTypeClass *) klass)->is_real_struct_type = (gboolean (*) (ValaDataType*)) vala_data_type_real_is_real_struct_type;
	((ValaDataTypeClass *) klass)->is_disposable = (gboolean (*) (ValaDataType*)) vala_data_type_real_is_disposable;
	((ValaDataTypeClass *) klass)->get_actual_type = (ValaDataType* (*) (ValaDataType*, ValaDataType*, ValaList*, ValaCodeNode*)) vala_data_type_real_get_actual_type;
	((ValaDataTypeClass *) klass)->infer_type_argument = (ValaDataType* (*) (ValaDataType*, ValaTypeParameter*, ValaDataType*)) vala_data_type_real_infer_type_argument;
	((ValaDataTypeClass *) klass)->to_prototype_string = (gchar* (*) (ValaDataType*, const gchar*)) vala_data_type_real_to_prototype_string;
}

static void
vala_data_type_instance_init (ValaDataType * self,
                              gpointer klass)
{
	self->priv = vala_data_type_get_instance_private (self);
}

static void
vala_data_type_finalize (ValaCodeNode * obj)
{
	ValaDataType * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_DATA_TYPE, ValaDataType);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_data_type_parent_class)->finalize (obj);
}

/**
 * A reference to a data type. This is used to specify static types of
 * expressions.
 */
static GType
vala_data_type_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaDataTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_data_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDataType), 0, (GInstanceInitFunc) vala_data_type_instance_init, NULL };
	GType vala_data_type_type_id;
	vala_data_type_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaDataType", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ValaDataType_private_offset = g_type_add_instance_private (vala_data_type_type_id, sizeof (ValaDataTypePrivate));
	return vala_data_type_type_id;
}

GType
vala_data_type_get_type (void)
{
	static volatile gsize vala_data_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_data_type_type_id__volatile)) {
		GType vala_data_type_type_id;
		vala_data_type_type_id = vala_data_type_get_type_once ();
		g_once_init_leave (&vala_data_type_type_id__volatile, vala_data_type_type_id);
	}
	return vala_data_type_type_id__volatile;
}

