/*
 * ===========================
 * VDK Visual Development Kit
 * Version 2.0.2
 * April 2002
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef _vdkdockable_h
#define _vdkdockable_h
#include <vdk/boxes.h>
#include <vdk/forms.h>

#define docked_signal 2048
#define undocked_signal 2049

class VDKDockerBoxForm;
/*!
  \class VDKDockerBox
  \brief Provides a box that can be detached from his container
  and attached (docked) into a separate form.
 */
class VDKDockerBox : public VDKBox
{
  void Dock ();
  void Undock ();
  int justify, fill, expand, padding;
  friend class VDKObjectContainer;
  friend class VDKDockerBoxForm;
  void SetDocked (bool flag);
  bool GetDocked ();

  protected:

  VDKDockerBoxForm* dock_form;
  public:
  /*!
    docks undocks the box
   */
  VDKReadWriteValueProp <VDKDockerBox, bool> Docked;
  /*!
    constructor
    \param owner the owner form
    \param mode either vertical or horizontal box
  */
  VDKDockerBox (VDKForm* owner,  int mode = v_box);
  /*!
    destructor
  */
  virtual ~VDKDockerBox ();

  VDKDockerBoxForm* DockForm() { return dock_form; }
  
};

class VDKDockerBoxForm: public VDKForm
{
  friend class VDKDockerBox;
  VDKObjectContainer* box_from; 
  VDKDockerBox* docker;
  VDKDockerBoxForm (VDKForm* owner,  char* title = NULL);
  ~VDKDockerBoxForm ();
  void Setup ();
  bool CanClose ();
  };
#endif
