/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.norender.browser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Vector3f;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.browser.EventModelStatusListener;
import org.web3d.browser.NavigationStateListener;
import org.web3d.browser.SensorStatusListener;
import org.web3d.browser.ViewpointStatusListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.renderer.norender.browser.PerFrameManager;
import org.web3d.vrml.renderer.norender.nodes.NRVRMLNode;
import org.xj3d.core.eventmodel.EventModelEvaluator;
import org.xj3d.core.eventmodel.EventModelInitListener;

public class NRUniverse
implements BrowserCore,
EventModelInitListener {
    private static final float INFINITE_VIS_LIMIT = 10000.0f;
    private static final int VP_TRANSITION_TIME = 2000;
    private String worldDescription;
    private VRMLScene currentScene;
    private VRMLScene nextScene;
    private VRMLExecutionSpace currentSpace;
    private Map defMap;
    private PerFrameManager frameManager;
    private EventModelEvaluator eventModel;
    private ErrorReporter errorReporter;
    private ArrayList coreListeners;
    private ArrayList viewpointStatusListeners;
    private int frameCycleTime;
    private int userCycleTime;
    private int internalCycleTime;

    public NRUniverse(EventModelEvaluator eventModelEvaluator) {
        this.eventModel = eventModelEvaluator;
        this.eventModel.setInitListener(this);
        this.defMap = Collections.EMPTY_MAP;
        this.coreListeners = new ArrayList();
        this.viewpointStatusListeners = new ArrayList(1);
        this.frameManager = new PerFrameManager(this.eventModel);
        this.frameManager.setEnable(false);
        this.frameManager.start();
        this.frameCycleTime = 0;
        this.userCycleTime = 0;
        this.internalCycleTime = 0;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void worldInitComplete() {
        this.fireInitEvent();
    }

    public void changeWorld() {
        if (this.currentScene != null) {
            this.fireShutdownEvent();
            this.clearCurrentWorld();
        }
        this.currentScene = this.nextScene;
        if (this.currentScene == null) {
            return;
        }
        this.frameManager.setEnable(false);
        if (this.currentScene != null) {
            this.fireShutdownEvent();
            this.clearCurrentWorld();
        }
        this.defMap = this.currentScene.getDEFNodes();
        NRVRMLNode nRVRMLNode = (NRVRMLNode)this.currentScene.getRootNode();
        this.currentSpace = (VRMLExecutionSpace)((Object)nRVRMLNode);
        VRMLClock vRMLClock = this.eventModel.getVRMLClock();
        vRMLClock.resetTimeZero();
        this.frameManager.setEnable(true);
    }

    public int getRendererType() {
        return 2;
    }

    public String getIDString() {
        return "norender";
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (this.errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void setRenderingStyle(int n) throws IllegalArgumentException {
    }

    public int getRenderingStyle() {
        return 4;
    }

    public void setMinimumFrameInterval(int n, boolean bl) {
        if (bl) {
            this.userCycleTime = n;
        } else {
            this.internalCycleTime = n;
        }
        this.frameCycleTime = this.userCycleTime >= this.internalCycleTime ? this.userCycleTime : this.internalCycleTime;
    }

    public int getMinimumFrameInterval() {
        return this.frameCycleTime;
    }

    public VRMLClock getVRMLClock() {
        return this.eventModel.getVRMLClock();
    }

    public Map getDEFMappings() {
        return this.defMap;
    }

    public VRMLExecutionSpace getWorldExecutionSpace() {
        return this.currentSpace;
    }

    public String getDescription() {
        return this.worldDescription;
    }

    public void setDescription(String string) {
        this.worldDescription = string;
    }

    public float getCurrentSpeed() {
        return 0.0f;
    }

    public float getCurrentFrameRate() {
        return 0.0f;
    }

    public void setLastRenderTime(long l) {
    }

    public void setEventModelStatusListener(EventModelStatusListener eventModelStatusListener) {
    }

    public void addNavigationStateListener(NavigationStateListener navigationStateListener) {
    }

    public void removeNavigationStateListener(NavigationStateListener navigationStateListener) {
    }

    public void addSensorStatusListener(SensorStatusListener sensorStatusListener) {
    }

    public void removeSensorStatusListener(SensorStatusListener sensorStatusListener) {
    }

    public void addViewpointStatusListener(ViewpointStatusListener viewpointStatusListener) {
        if (viewpointStatusListener != null && !this.viewpointStatusListeners.contains(viewpointStatusListener)) {
            this.viewpointStatusListeners.add(viewpointStatusListener);
        }
    }

    public void removeViewpointStatusListener(ViewpointStatusListener viewpointStatusListener) {
        this.viewpointStatusListeners.remove(viewpointStatusListener);
    }

    public void dispose() {
        this.fireDisposeEvent();
    }

    public String getWorldURL() {
        String string = null;
        if (this.currentScene != null) {
            string = this.currentScene.getWorldRootURL();
        }
        return string;
    }

    public void setScene(VRMLScene vRMLScene, String string) {
        this.nextScene = vRMLScene;
        this.eventModel.setScene(vRMLScene, string);
        this.frameManager.setEnable(true);
    }

    public void changeViewpoint(VRMLViewpointNodeType vRMLViewpointNodeType) {
        this.eventModel.changeViewpoint(vRMLViewpointNodeType);
    }

    public void addCoreListener(BrowserCoreListener browserCoreListener) {
        if (browserCoreListener != null && !this.coreListeners.contains(browserCoreListener)) {
            this.coreListeners.add(browserCoreListener);
        }
    }

    public void removeCoreListener(BrowserCoreListener browserCoreListener) {
        this.coreListeners.remove(browserCoreListener);
    }

    public void setNavigationMode(String string) {
    }

    public void getUserPosition(Vector3f vector3f, AxisAngle4f axisAngle4f) {
    }

    public void fitToWorld(boolean bl) {
    }

    public void syncUIUpdates() {
    }

    public void setNavigationStateListener(NavigationStateListener navigationStateListener) {
    }

    public void sendURLFailEvent(String string) {
        this.fireFailedURL(string);
    }

    public VRMLScene getScene() {
        return this.currentScene;
    }

    private void clearCurrentWorld() {
        this.frameManager.setEnable(false);
        this.currentSpace = null;
        this.eventModel.clear();
        this.clearInlines(this.currentScene);
    }

    private void clearInlines(BasicScene basicScene) {
        VRMLNodeType vRMLNodeType;
        int n;
        ArrayList arrayList = basicScene.getByPrimaryType(24);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (NRVRMLNode)arrayList.get(n);
            VRMLScene vRMLScene = (VRMLScene)((VRMLInlineNodeType)vRMLNodeType).getContainedScene();
            if (vRMLScene == null) continue;
            this.clearInlines(vRMLScene);
        }
        arrayList = basicScene.getByPrimaryType(38);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLProtoInstance)arrayList.get(n);
            this.clearInlines(vRMLNodeType.getContainedScene());
        }
    }

    private void fireInitEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserInitialized(this.currentScene);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireFailedURL(String string) {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.urlLoadFailed(string);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireShutdownEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserShutdown();
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireDisposeEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserDisposed();
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }
}

