(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)

Require Export Caduceus.

(*Why type*) Definition global: Set.
Admitted.

(*Why type*) Definition plist: Set.
exact (plist global).
Defined.

(*Why type*) Definition Length: Set.
exact (Length global).
Defined.

(*Why logic*) Definition lpath :
  (memory (pointer global) global) -> alloc_table -> (pointer global)
  -> plist -> (pointer global) -> Prop.
exact (fun m a => lpath _ a (acc m)).
Defined.

(*Why logic*) Definition cons : (pointer global) -> plist -> plist.
exact (fun p => cons p).
Defined.

(*Why axiom*) Lemma Path_cons_inv :
  (forall (tl_global:(memory (pointer global) global)),
   (forall (alloc:alloc_table),
    (* CADUCEUS_8 *)
    (forall (p1:(pointer global)),
     (forall (l:plist),
      (forall (p2:(pointer global)),
       ((valid alloc p1) /\
        (lpath tl_global alloc (acc tl_global p1) l p2) <->
        (lpath tl_global alloc p1 (cons p1 l) p2))))))).
Admitted.

(*Why logic*) Definition nil : plist.
exact nil.
Defined.

(*Why axiom*) Lemma Path_null_ax :
  (forall (tl_global:(memory (pointer global) global)),
   (forall (alloc:alloc_table),
    (* CADUCEUS_6 *)
    (forall (p:(pointer global)), (lpath tl_global alloc p nil p)))).
Admitted.

(*Why axiom*) Lemma Path_null_inv_ax :
  (forall (tl_global:(memory (pointer global) global)),
   (forall (alloc:alloc_table),
    (* CADUCEUS_7 *)
    (forall (p:(pointer global)),
     (forall (l:plist), ((lpath tl_global alloc p l p) -> l = nil))))).
Admitted.

(*Why logic*) Definition app : plist -> plist -> plist.
exact (fun p => app p).
Defined.

(*Why axiom*) Lemma app_nil_1_ax :
  (* CADUCEUS_2 *) (forall (l:plist), l = (app l nil)).
Admitted.

(*Why axiom*) Lemma app_nil_2_ax :
  (* CADUCEUS_3 *) (forall (l:plist), l = (app nil l)).
Admitted.

(*Why logic*) Definition cyclic :
  (memory (pointer global) global) -> (pointer global) -> Prop.
Admitted.

(*Why logic*) Definition disjoint : plist -> plist -> Prop.
exact (fun p => disjoint _ p).
Defined.

(*Why axiom*) Lemma disjoint_nil1 :
  (* CADUCEUS_4 *) (forall (l:plist), (disjoint l nil)).
Admitted.

(*Why axiom*) Lemma disjoint_nil2 :
  (* CADUCEUS_5 *) (forall (l:plist), (disjoint nil l)).
Admitted.

(*Why logic*) Definition finite :
  (memory (pointer global) global) -> (pointer global) -> Prop.
Admitted.

(*Why predicate*) Definition llist  (tl_global:(memory (pointer global) global)) (alloc:alloc_table) (p:(pointer global)) (l:plist)
  := (* CADUCEUS_9 *) (lpath tl_global alloc p l (@null global)).

(*Why predicate*) Definition is_list  (tl_global:(memory (pointer global) global)) (alloc:alloc_table) (l:(pointer global))
  := (* CADUCEUS_10 *) (exists pl:plist, (llist tl_global alloc l pl)).

(*Why axiom*) Lemma is_list_llist_ax :
  (forall (tl_global:(memory (pointer global) global)),
   (forall (alloc:alloc_table),
    (* CADUCEUS_11 *)
    (forall (p:(pointer global)),
     ((is_list tl_global alloc p) <->
      (exists l:plist, (llist tl_global alloc p l)))))).
Admitted.

(*Why logic*) Definition length :
  (memory (pointer global) global) -> (pointer global) -> Length.
exact (fun tl p => length global tl p). 
Defined.

(*Why logic*) Definition length_order : Length -> Length -> Prop.
exact (length_order global).
Defined.

(*Why logic*) Definition list_length : plist -> Z.
exact (fun l => Z_of_nat (List.length l)).
Defined.

(*Why axiom*) Lemma llist_function_ax :
  (forall (tl_global:(memory (pointer global) global)),
   (forall (alloc:alloc_table),
    (* CADUCEUS_12 *)
    (forall (l1:plist),
     (forall (l2:plist),
      (forall (p:(pointer global)),
       ((llist tl_global alloc p l1) ->
        ((llist tl_global alloc p l2) -> l1 = l2))))))).
Admitted.

(*Why axiom*) Lemma llist_valid :
  (forall (tl_global:(memory (pointer global) global)),
   (forall (alloc:alloc_table),
    (* CADUCEUS_13 *)
    (forall (p1:(pointer global)),
     (forall (l:plist),
      ((llist tl_global alloc p1 l) ->
       (~(p1 = (@null global)) -> (valid alloc p1))))))).
Admitted.

(*Why logic*) Definition rev : plist -> plist.
exact (fun l => rev l).
Defined.

(*Why axiom*) Lemma rev_nil_ax : (* CADUCEUS_1 *) (rev nil) = nil.
Admitted.

