/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

class TransformManager11
extends TransformManager {
    private float navigationSlabOffset;
    private float zoomFactor = Float.MAX_VALUE;
    private static final int NAV_MODE_IGNORE = -2;
    private static final int NAV_MODE_ZOOMED = -1;
    private static final int NAV_MODE_NONE = 0;
    private static final int NAV_MODE_RESET = 1;
    private static final int NAV_MODE_NEWXY = 2;
    private static final int NAV_MODE_NEWXYZ = 3;
    private static final int NAV_MODE_NEWZ = 4;
    private int navMode = 1;
    float navigationDepth;
    private int nHits;
    private int multiplier = 1;
    protected Point3f ptMoveToCenter;

    TransformManager11() {
        this.setNavFps(10);
    }

    TransformManager11(Viewer viewer) {
        super(viewer);
        this.setNavFps(10);
    }

    protected void setNavFps(int n) {
        this.navFps = n;
    }

    TransformManager11(Viewer viewer, int n, int n2) {
        super(viewer, n, n2);
        this.setNavFps(10);
    }

    void zoomByFactor(float f, int n, int n2) {
        if (!this.zoomEnabled || f <= 0.0f || this.mode != 1) {
            super.zoomByFactor(f, n, n2);
            return;
        }
        if (this.navZ > 0.0f) {
            this.navZ /= f;
            if (this.navZ < 5.0f) {
                this.navZ = -5.0f;
            } else if (this.navZ > 200.0f) {
                this.navZ = 200.0f;
            }
        } else if (this.navZ == 0.0f) {
            this.navZ = f < 1.0f ? 5 : -5;
        } else {
            this.navZ *= f;
            if (this.navZ > -5.0f) {
                this.navZ = 5.0f;
            } else if (this.navZ < -200.0f) {
                this.navZ = -200.0f;
            }
        }
    }

    protected void calcCameraFactors() {
        if (Float.isNaN(this.cameraDepth)) {
            this.cameraDepth = this.cameraDepthSetting;
            this.zoomFactor = Float.MAX_VALUE;
        }
        this.cameraDistance = this.cameraDepth * (float)this.screenPixelCount;
        this.referencePlaneOffset = this.cameraDistance + (float)this.screenPixelCount / 2.0f;
        this.scalePixelsPerAngstrom = this.scale3D && !this.perspectiveDepth && this.mode != 1 ? 72.0f / this.scale3DAngstromsPerInch : (float)this.screenPixelCount / this.visualRange;
        this.modelRadiusPixels = this.modelRadius * this.scalePixelsPerAngstrom;
        float f = 2.0f * this.modelRadius / this.visualRange * this.referencePlaneOffset;
        if (this.mode != 1) {
            this.zoomFactor = Float.MAX_VALUE;
            this.modelCenterOffset = this.referencePlaneOffset;
            if (!this.scale3D || this.perspectiveDepth) {
                this.scalePixelsPerAngstrom *= this.modelCenterOffset / f * this.zoomPercent / 100.0f;
            }
            this.modelRadiusPixels = this.modelRadius * this.scalePixelsPerAngstrom;
            return;
        }
        if (this.zoomFactor == Float.MAX_VALUE) {
            if (this.zoomPercent > 10000.0f) {
                this.zoomPercent = 10000.0f;
            }
            this.modelCenterOffset = f * 100.0f / this.zoomPercent;
        } else if (this.prevZoomSetting != this.zoomPercentSetting) {
            this.modelCenterOffset = this.zoomRatio == 0.0f ? f * 100.0f / this.zoomPercentSetting : (this.modelCenterOffset += (1.0f - this.zoomRatio) * this.referencePlaneOffset);
            this.navMode = -1;
        }
        this.prevZoomSetting = this.zoomPercentSetting;
        this.zoomFactor = this.modelCenterOffset / this.referencePlaneOffset;
        this.zoomPercent = this.zoomFactor == 0.0f ? 10000.0f : f / this.modelCenterOffset * 100.0f;
    }

    protected float getPerspectiveFactor(float f) {
        return f <= 0.0f ? this.referencePlaneOffset : this.referencePlaneOffset / f;
    }

    protected void adjustTemporaryScreenPoint() {
        float f = this.point3fScreenTemp.z;
        if (Float.isNaN(f)) {
            if (!this.haveNotifiedNaN) {
                Logger.debug("NaN seen in TransformPoint");
            }
            this.haveNotifiedNaN = true;
            f = 1.0f;
        } else if (f <= 0.0f) {
            f = 1.0f;
        }
        this.point3fScreenTemp.z = f;
        switch (this.mode) {
            case 1: {
                this.point3fScreenTemp.x -= this.navigationShiftXY.x;
                this.point3fScreenTemp.y -= this.navigationShiftXY.y;
                break;
            }
            case 2: {
                this.point3fScreenTemp.x -= this.perspectiveShiftXY.x;
                this.point3fScreenTemp.y -= this.perspectiveShiftXY.y;
            }
        }
        if (this.perspectiveDepth) {
            float f2 = this.getPerspectiveFactor(f);
            this.point3fScreenTemp.x *= f2;
            this.point3fScreenTemp.y *= f2;
        }
        switch (this.mode) {
            case 1: {
                this.point3fScreenTemp.x += this.navigationOffset.x;
                this.point3fScreenTemp.y += this.navigationOffset.y;
                break;
            }
            case 2: {
                this.point3fScreenTemp.x += this.perspectiveOffset.x;
                this.point3fScreenTemp.y += this.perspectiveOffset.y;
                break;
            }
            case 0: {
                this.point3fScreenTemp.x += this.fixedRotationOffset.x;
                this.point3fScreenTemp.y += this.fixedRotationOffset.y;
            }
        }
        if (Float.isNaN(this.point3fScreenTemp.x) && !this.haveNotifiedNaN) {
            Logger.debug("NaN found in transformPoint ");
            this.haveNotifiedNaN = true;
        }
        this.point3iScreenTemp.set((int)this.point3fScreenTemp.x, (int)this.point3fScreenTemp.y, (int)this.point3fScreenTemp.z);
    }

    void setScreenParameters(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Point3f point3f = this.mode == 1 ? new Point3f(this.navigationCenter) : null;
        Point3f point3f2 = new Point3f(this.navigationOffset);
        point3f2.x /= (float)this.width;
        point3f2.y /= (float)this.height;
        super.setScreenParameters(n, n2, bl, bl2, bl3, bl4);
        if (point3f != null) {
            this.navigationCenter.set(point3f);
            this.navTranslatePercent(-1.0f, point3f2.x * (float)this.width, point3f2.y * (float)this.height);
            this.navigate(0.0f, point3f);
        }
    }

    protected void calcNavigationPoint() {
        float f;
        this.calcNavigationDepthPercent();
        if (!this.navigating && this.navMode != 1) {
            this.navMode = this.navigationDepth < 100.0f && this.navigationDepth > 0.0f && !Float.isNaN(this.previousX) && this.previousX == this.fixedTranslation.x && this.previousY == this.fixedTranslation.y && this.navMode != -1 ? 3 : 0;
        }
        switch (this.navMode) {
            case 1: {
                this.navigationOffset.set((float)this.width / 2.0f, this.getNavPtHeight(), this.referencePlaneOffset);
                this.zoomFactor = Float.MAX_VALUE;
                this.calcCameraFactors();
                this.calcTransformMatrix();
                this.newNavigationCenter();
                break;
            }
            case -1: 
            case 0: {
                this.fixedRotationOffset.set(this.fixedTranslation);
                this.newNavigationCenter();
                break;
            }
            case 2: {
                this.newNavigationCenter();
                break;
            }
            case -2: 
            case 3: {
                this.matrixTransform.transform(this.navigationCenter, this.pointT);
                f = this.pointT.z;
                this.matrixTransform.transform(this.fixedRotationCenter, this.pointT);
                this.modelCenterOffset = this.referencePlaneOffset + (this.pointT.z - f);
                this.calcCameraFactors();
                this.calcTransformMatrix();
                break;
            }
            case 4: {
                this.navigationOffset.z = this.referencePlaneOffset;
                this.unTransformPoint(this.navigationOffset, this.navigationCenter);
            }
        }
        this.matrixTransform.transform(this.navigationCenter, this.navigationShiftXY);
        if (this.viewer.getNavigationPeriodic()) {
            this.viewer.toUnitCell(this.navigationCenter, null);
            if ((double)this.pointT.distance(this.navigationCenter) > 0.01) {
                this.matrixTransform.transform(this.navigationCenter, this.pointT);
                f = this.navigationShiftXY.z - this.pointT.z;
                this.modelCenterOffset += f;
                this.calcCameraFactors();
                this.calcTransformMatrix();
                this.matrixTransform.transform(this.navigationCenter, this.navigationShiftXY);
            }
        }
        this.transformPoint(this.fixedRotationCenter, this.fixedTranslation);
        this.fixedRotationOffset.set(this.fixedTranslation);
        this.previousX = this.fixedTranslation.x;
        this.previousY = this.fixedTranslation.y;
        this.transformPoint(this.navigationCenter, this.navigationOffset);
        this.navigationOffset.z = this.referencePlaneOffset;
        this.navMode = 0;
        this.calcNavigationSlabAndDepth();
    }

    private float getNavPtHeight() {
        boolean bl = this.viewer.getNavigateSurface();
        return (float)this.height / (bl ? 1.0f : 2.0f);
    }

    protected void calcNavigationSlabAndDepth() {
        this.slabValue = 0;
        this.depthValue = Integer.MAX_VALUE;
        if (!this.slabEnabled) {
            return;
        }
        this.zSlabValue = this.slabValue = (this.mode == 1 ? -100 : 0) + (int)(this.referencePlaneOffset - this.navigationSlabOffset);
        this.zDepthValue = this.depthValue = this.zValueFromPercent(this.depthPercentSetting);
        this.viewer.getGlobalSettings().setParameterValue("navigationDepth", this.getNavigationDepthPercent());
        this.viewer.getGlobalSettings().setParameterValue("navigationSlab", this.getNavigationSlabOffsetPercent());
        if (Logger.debugging) {
            Logger.debug("\n\nperspectiveScale: " + this.referencePlaneOffset + " screenPixelCount: " + this.screenPixelCount + "\nmodelTrailingEdge: " + (this.modelCenterOffset + this.modelRadiusPixels) + " depthValue: " + this.depthValue + "\nmodelCenterOffset: " + this.modelCenterOffset + " modelRadiusPixels: " + this.modelRadiusPixels + "\nmodelLeadingEdge: " + (this.modelCenterOffset - this.modelRadiusPixels) + " slabValue: " + this.slabValue + "\nzoom: " + this.zoomPercent + " navDepth: " + (float)((int)(100.0f * this.getNavigationDepthPercent())) / 100.0f + " visualRange: " + this.visualRange + "\nnavX/Y/Z/modelCenterOffset: " + this.navigationOffset.x + "/" + this.navigationOffset.y + "/" + this.navigationOffset.z + "/" + this.modelCenterOffset + " navCenter:" + this.navigationCenter);
        }
    }

    private void newNavigationCenter() {
        this.mode = this.defaultMode;
        this.transformPoint(this.fixedRotationCenter, this.pointT);
        this.pointT.x -= this.navigationOffset.x;
        this.pointT.y -= this.navigationOffset.y;
        float f = -this.getPerspectiveFactor(this.pointT.z);
        this.pointT.x /= f;
        this.pointT.y /= f;
        this.pointT.z = this.referencePlaneOffset;
        this.matrixUnTransform(this.pointT, this.navigationCenter);
        this.mode = 1;
    }

    boolean canNavigate() {
        return true;
    }

    protected void resetNavigationPoint(boolean bl) {
        if (this.zoomPercent < 5.0f && this.mode != 1) {
            this.perspectiveDepth = true;
            this.mode = 1;
            return;
        }
        if (this.mode == 1) {
            this.navMode = 1;
            this.slabPercentSetting = 0;
            this.perspectiveDepth = true;
        } else if (bl) {
            this.slabPercentSetting = 100;
        }
        if (bl) {
            this.slabEnabled = this.mode == 1;
        }
        this.zoomFactor = Float.MAX_VALUE;
        this.zoomPercentSetting = this.zoomPercent;
    }

    protected void setNavigationOffsetRelative(boolean bl) {
        if (bl) {
            this.navigateSurface(Integer.MAX_VALUE);
            return;
        }
        if (this.navigationDepth < 0.0f && this.navZ > 0.0f || this.navigationDepth > 100.0f && this.navZ < 0.0f) {
            this.navZ = 0.0f;
        }
        this.rotateXRadians(-3.4906584E-4f * this.navY, null);
        this.rotateYRadians(3.4906584E-4f * this.navX, null);
        Point3f point3f = this.getNavigationCenter();
        Point3f point3f2 = new Point3f();
        this.transformPoint(point3f, point3f2);
        point3f2.z += this.navZ;
        this.unTransformPoint(point3f2, point3f);
        this.navigate(0.0f, point3f);
    }

    synchronized void navigate(int n, int n2) {
        String string = null;
        float f = 0.0f;
        if (this.mode != 1) {
            return;
        }
        if (n == 0) {
            this.nHits = 0;
            this.multiplier = 1;
            if (!this.navigating) {
                return;
            }
            this.navigating = false;
            return;
        }
        ++this.nHits;
        if (this.nHits % 10 == 0) {
            this.multiplier *= this.multiplier == 4 ? 1 : 2;
        }
        boolean bl = this.viewer.getNavigateSurface();
        boolean bl2 = (n2 & 1) > 0;
        boolean bl3 = (n2 & 8) > 0;
        boolean bl4 = (n2 & 2) > 0;
        float f2 = this.viewer.getNavigationSpeed() * (float)(bl4 ? 10 : 1);
        switch (n) {
            case 46: {
                this.navZ = 0.0f;
                this.navY = 0.0f;
                this.navX = 0.0f;
                this.homePosition();
                return;
            }
            case 32: {
                if (!this.navOn) {
                    return;
                }
                this.navZ = 0.0f;
                this.navY = 0.0f;
                this.navX = 0.0f;
                return;
            }
            case 38: {
                if (this.navOn) {
                    if (bl3) {
                        this.navY += (float)this.multiplier;
                        f = this.navY;
                        string = "navY";
                        break;
                    }
                    this.navZ += (float)this.multiplier;
                    f = this.navZ;
                    string = "navZ";
                    break;
                }
                if (bl) {
                    this.navigateSurface(Integer.MAX_VALUE);
                    break;
                }
                if (bl2) {
                    this.navigationOffset.y -= (float)(2 * this.multiplier);
                    this.navMode = 2;
                    break;
                }
                if (bl3) {
                    this.rotateXRadians(-0.0034906585f * (float)this.multiplier, null);
                    this.navMode = 3;
                    break;
                }
                this.modelCenterOffset -= f2 * (float)(this.viewer.getNavigationPeriodic() ? 1 : this.multiplier);
                this.navMode = 4;
                break;
            }
            case 40: {
                if (this.navOn) {
                    if (bl3) {
                        this.navY -= (float)this.multiplier;
                        f = this.navY;
                        string = "navY";
                        break;
                    }
                    this.navZ -= (float)this.multiplier;
                    f = this.navZ;
                    string = "navZ";
                    break;
                }
                if (bl) {
                    this.navigateSurface(-2 * this.multiplier);
                    break;
                }
                if (bl2) {
                    this.navigationOffset.y += (float)(2 * this.multiplier);
                    this.navMode = 2;
                    break;
                }
                if (bl3) {
                    this.rotateXRadians(0.0034906585f * (float)this.multiplier, null);
                    this.navMode = 3;
                    break;
                }
                this.modelCenterOffset += f2 * (float)(this.viewer.getNavigationPeriodic() ? 1 : this.multiplier);
                this.navMode = 4;
                break;
            }
            case 37: {
                if (this.navOn) {
                    this.navX -= (float)this.multiplier;
                    f = this.navX;
                    string = "navX";
                    break;
                }
                if (bl) break;
                if (bl2) {
                    this.navigationOffset.x -= (float)(2 * this.multiplier);
                    this.navMode = 2;
                    break;
                }
                this.rotateYRadians(-0.010471976f * (float)this.multiplier, null);
                this.navMode = 3;
                break;
            }
            case 39: {
                if (this.navOn) {
                    this.navX += (float)this.multiplier;
                    f = this.navX;
                    string = "navX";
                    break;
                }
                if (bl) break;
                if (bl2) {
                    this.navigationOffset.x += (float)(2 * this.multiplier);
                    this.navMode = 2;
                    break;
                }
                this.rotateYRadians(0.010471976f * (float)this.multiplier, null);
                this.navMode = 3;
                break;
            }
            default: {
                this.navigating = false;
                this.navMode = 0;
                return;
            }
        }
        if (string != null) {
            this.viewer.getGlobalSettings().setParameterValue(string, f);
        }
        this.navigating = true;
        this.finalizeTransformParameters();
    }

    private void navigateSurface(int n) {
        if (this.viewer.isRepaintPending()) {
            return;
        }
        this.viewer.setShapeProperty(23, "navigate", new Integer(n == Integer.MAX_VALUE ? 2 * this.multiplier : n));
        this.viewer.requestRepaintAndWait();
    }

    void navigate(float f, Point3f point3f) {
        if (f > 0.0f) {
            this.navigateTo(f, null, Float.NaN, point3f, Float.NaN, Float.NaN, Float.NaN);
            return;
        }
        this.navigationCenter.set(point3f);
        this.navMode = 3;
        this.navigating = true;
        this.finalizeTransformParameters();
        this.navigating = false;
    }

    void navigate(float f, Vector3f vector3f, float f2) {
        if (f2 == 0.0f) {
            return;
        }
        if (f > 0.0f) {
            this.navigateTo(f, vector3f, f2, null, Float.NaN, Float.NaN, Float.NaN);
            return;
        }
        this.rotateAxisAngle(vector3f, (float)((double)f2 / 57.29577951308232));
        this.navMode = 3;
        this.navigating = true;
        this.finalizeTransformParameters();
        this.navigating = false;
    }

    void setNavigationDepthPercent(float f, float f2) {
        if (f > 0.0f) {
            this.navigateTo(f, null, Float.NaN, null, f2, Float.NaN, Float.NaN);
            return;
        }
        this.setNavigationDepthPercent(f2);
    }

    void navTranslate(float f, Point3f point3f) {
        this.transformPoint(point3f, this.pointT);
        if (f > 0.0f) {
            this.navigateTo(f, null, Float.NaN, null, Float.NaN, this.pointT.x, this.pointT.y);
            return;
        }
        this.navTranslatePercent(-1.0f, this.pointT.x, this.pointT.y);
    }

    void navTranslatePercent(float f, float f2, float f3) {
        this.transformPoint(this.navigationCenter, this.navigationOffset);
        if (f >= 0.0f) {
            if (!Float.isNaN(f2)) {
                f2 = (float)this.width * f2 / 100.0f + (Float.isNaN(f3) ? this.navigationOffset.x : (float)this.width / 2.0f);
            }
            if (!Float.isNaN(f3)) {
                f3 = (float)this.height * f3 / 100.0f + (Float.isNaN(f2) ? this.navigationOffset.y : this.getNavPtHeight());
            }
        }
        if (f > 0.0f) {
            this.navigateTo(f, null, Float.NaN, null, Float.NaN, f2, f3);
            return;
        }
        if (!Float.isNaN(f2)) {
            this.navigationOffset.x = f2;
        }
        if (!Float.isNaN(f3)) {
            this.navigationOffset.y = f3;
        }
        this.navMode = 2;
        this.navigating = true;
        this.finalizeTransformParameters();
        this.navigating = false;
    }

    private void navigateTo(float f, Vector3f vector3f, float f2, Point3f point3f, float f3, float f4, float f5) {
        if (!this.viewer.haveDisplay) {
            f = 0.0f;
        }
        this.ptMoveToCenter = point3f == null ? this.navigationCenter : point3f;
        int n = 30;
        int n2 = (int)(f * (float)n);
        if (f > 0.0f) {
            this.viewer.setInMotion(true);
        }
        if (f2 == 0.0f) {
            f2 = Float.NaN;
        }
        if (n2 > 1) {
            int n3 = 1000 / n;
            long l = System.currentTimeMillis();
            float f6 = this.getNavigationDepthPercent();
            float f7 = f3 - f6;
            float f8 = this.navigationOffset.x;
            float f9 = f4 - f8;
            float f10 = this.navigationOffset.y;
            float f11 = f5 - f10;
            float f12 = f2 / (float)n2;
            Vector3f vector3f2 = new Vector3f();
            vector3f2.set(this.ptMoveToCenter);
            vector3f2.sub(this.navigationCenter);
            vector3f2.scale(1.0f / (float)n2);
            Point3f point3f2 = new Point3f(this.navigationCenter);
            for (int i = 1; i < n2; ++i) {
                this.navigating = true;
                float f13 = (float)i / ((float)n2 - 1.0f);
                if (!Float.isNaN(f2)) {
                    this.navigate(0.0f, vector3f, f12);
                }
                if (point3f != null) {
                    point3f2.add(vector3f2);
                    this.navigate(0.0f, point3f2);
                }
                if (!Float.isNaN(f4) || !Float.isNaN(f5)) {
                    float f14 = Float.NaN;
                    float f15 = Float.NaN;
                    if (!Float.isNaN(f4)) {
                        f14 = f8 + f9 * f13;
                    }
                    if (!Float.isNaN(f5)) {
                        f15 = f10 + f11 * f13;
                    }
                    this.navTranslatePercent(-1.0f, f14, f15);
                }
                if (!Float.isNaN(f3)) {
                    this.setNavigationDepthPercent(f6 + f7 * f13);
                }
                this.navigating = false;
                if (System.currentTimeMillis() >= (l += (long)n3)) continue;
                this.viewer.requestRepaintAndWait();
                if (!this.viewer.isScriptExecuting()) {
                    return;
                }
                int n4 = (int)(l - System.currentTimeMillis());
                if (n4 <= 0) continue;
                try {
                    Thread.sleep(n4);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        } else {
            int n5 = (int)(f * 1000.0f) - 30;
            if (n5 > 0) {
                try {
                    Thread.sleep(n5);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (!Float.isNaN(f4) || !Float.isNaN(f5)) {
            this.navTranslatePercent(-1.0f, f4, f5);
        }
        if (!Float.isNaN(f3)) {
            this.setNavigationDepthPercent(f3);
        }
        this.viewer.setInMotion(false);
    }

    void navigate(float f, Point3f[][] point3fArray) {
        this.navigate(f, point3fArray, null, null, 0, Integer.MAX_VALUE);
    }

    void navigate(float f, Point3f[] point3fArray, float[] fArray, int n, int n2) {
        this.navigate(f, null, point3fArray, fArray, n, n2);
    }

    private void navigate(float f, Point3f[][] point3fArray, Point3f[] point3fArray2, float[] fArray, int n, int n2) {
        int n3;
        int n4;
        if (f <= 0.0f) {
            f = 2.0f;
        }
        if (!this.viewer.haveDisplay) {
            f = 0.0f;
        }
        boolean bl = point3fArray != null;
        if (!bl) {
            for (n4 = Math.min((bl ? point3fArray.length : point3fArray2.length) - 1, n2); n4 > 0 && point3fArray2[n4] == null; --n4) {
            }
        }
        if ((n4 -= n) < 1) {
            return;
        }
        int n5 = (int)(10.0f * f);
        int n6 = n4 * n5 + 1;
        Tuple3f[] tuple3fArray = new Point3f[n6 + 2];
        Tuple3f[] tuple3fArray2 = new Point3f[bl ? n6 + 2 : 0];
        for (n3 = 0; n3 < n4; ++n3) {
            int n7 = Math.max(n3 - 1, 0) + n;
            int n8 = n3 + n;
            int n9 = Math.min(n3 + 1, n4) + n;
            int n10 = Math.min(n3 + 2, n4) + n;
            int n11 = Math.min(n3 + 3, n4) + n;
            if (bl) {
                Graphics3D.getHermiteList(7, point3fArray[n7][0], point3fArray[n8][0], point3fArray[n9][0], point3fArray[n10][0], point3fArray[n11][0], tuple3fArray, n3 * n5, n5 + 1);
                Graphics3D.getHermiteList(7, point3fArray[n7][1], point3fArray[n8][1], point3fArray[n9][1], point3fArray[n10][1], point3fArray[n11][1], tuple3fArray2, n3 * n5, n5 + 1);
                continue;
            }
            Graphics3D.getHermiteList(7, point3fArray2[n7], point3fArray2[n8], point3fArray2[n9], point3fArray2[n10], point3fArray2[n11], tuple3fArray, n3 * n5, n5 + 1);
        }
        n3 = n6;
        this.viewer.setInMotion(true);
        int n12 = (int)(1000.0f / this.navFps);
        long l = System.currentTimeMillis();
        for (int i = 0; i < n3; ++i) {
            this.navigate(0.0f, tuple3fArray[i]);
            if (bl) {
                this.alignZX(tuple3fArray[i], tuple3fArray[i + 1], tuple3fArray2[i]);
            }
            if (System.currentTimeMillis() >= (l += (long)n12)) continue;
            this.viewer.requestRepaintAndWait();
            if (!this.viewer.isScriptExecuting()) {
                return;
            }
            int n13 = (int)(l - System.currentTimeMillis());
            if (n13 <= 0) continue;
            try {
                Thread.sleep(n13);
                continue;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    void navigateSurface(float f, String string) {
    }

    void alignZX(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        Point3f point3f4 = new Point3f();
        Point3f point3f5 = new Point3f();
        this.matrixRotate.transform(point3f, point3f4);
        this.matrixRotate.transform(point3f2, point3f5);
        Vector3f vector3f = new Vector3f(point3f4);
        vector3f.sub(point3f5);
        Vector3f vector3f2 = new Vector3f(0.0f, 0.0f, 1.0f);
        float f = vector3f.angle(vector3f2);
        vector3f2.cross(vector3f, vector3f2);
        if (f != 0.0f) {
            this.navigate(0.0f, vector3f2, (float)((double)f * 57.29577951308232));
        }
        this.matrixRotate.transform(point3f, point3f4);
        Point3f point3f6 = new Point3f(point3f3);
        point3f6.add(point3f);
        Point3f point3f7 = new Point3f();
        this.matrixRotate.transform(point3f6, point3f7);
        vector3f.set(point3f7);
        vector3f.sub(point3f4);
        vector3f.z = 0.0f;
        vector3f2.set(-1.0f, 0.0f, 0.0f);
        f = vector3f.angle(vector3f2);
        if (vector3f.y < 0.0f) {
            f = -f;
        }
        vector3f2.set(0.0f, 0.0f, 1.0f);
        if (f != 0.0f) {
            this.navigate(0.0f, vector3f2, (float)((double)f * 57.29577951308232));
        }
        if (this.viewer.getNavigateSurface()) {
            vector3f2.set(1.0f, 0.0f, 0.0f);
            this.navigate(0.0f, vector3f2, 20.0f);
        }
        this.matrixRotate.transform(point3f, point3f4);
        this.matrixRotate.transform(point3f2, point3f5);
        this.matrixRotate.transform(point3f3, point3f7);
    }

    Point3f getNavigationCenter() {
        return this.navigationCenter;
    }

    float getNavigationDepthPercent() {
        return this.navigationDepth;
    }

    void setNavigationSlabOffsetPercent(float f) {
        this.viewer.getGlobalSettings().setParameterValue("navigationSlab", f);
        this.calcCameraFactors();
        this.navigationSlabOffset = f / 50.0f * this.modelRadiusPixels;
    }

    private float getNavigationSlabOffsetPercent() {
        this.calcCameraFactors();
        return 50.0f * this.navigationSlabOffset / this.modelRadiusPixels;
    }

    Point3f getNavigationOffset() {
        this.transformPoint(this.navigationCenter, this.navigationOffset);
        return this.navigationOffset;
    }

    private void setNavigationDepthPercent(float f) {
        this.viewer.getGlobalSettings().setParameterValue("navigationDepth", f);
        this.calcCameraFactors();
        this.modelCenterOffset = this.referencePlaneOffset - (1.0f - f / 50.0f) * this.modelRadiusPixels;
        this.calcCameraFactors();
        this.navMode = -1;
    }

    private void calcNavigationDepthPercent() {
        this.calcCameraFactors();
        this.navigationDepth = this.modelRadiusPixels == 0.0f ? 50.0f : 50.0f * (1.0f + (this.modelCenterOffset - this.referencePlaneOffset) / this.modelRadiusPixels);
    }

    float getNavigationOffsetPercent(char c) {
        this.getNavigationOffset();
        if (this.width == 0 || this.height == 0) {
            return 0.0f;
        }
        return c == 'X' ? (this.navigationOffset.x - (float)this.width / 2.0f) * 100.0f / (float)this.width : (this.navigationOffset.y - this.getNavPtHeight()) * 100.0f / (float)this.height;
    }

    protected String getNavigationText(boolean bl) {
        this.getNavigationOffset();
        return (bl ? " /* navigation center, translation, depth */ " : " ") + Escape.escape(this.navigationCenter) + " " + this.getNavigationOffsetPercent('X') + " " + this.getNavigationOffsetPercent('Y') + " " + this.getNavigationDepthPercent();
    }

    protected String getNavigationState() {
        if (this.mode != 1) {
            return "";
        }
        return "# navigation state;\nnavigate 0 center " + Escape.escape(this.getNavigationCenter()) + ";\nnavigate 0 translate " + this.getNavigationOffsetPercent('X') + " " + this.getNavigationOffsetPercent('Y') + ";\nset navigationDepth " + this.getNavigationDepthPercent() + ";\nset navigationSlab " + this.getNavigationSlabOffsetPercent() + ";\n\n";
    }
}

