 /*
 *  file      : bacon.h
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2013 by Claude Bulin
 *
 *  Code from : bacon-message-connection.h
 *              Copyright (C) 2003
 *  By        : Bastien Nocera <hadess@hadess.net>
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef bacon_h
#define bacon_h 1


typedef void (*BaconMessageReceivedFunc) (const char *message, gpointer user_data);

typedef struct BaconMessageConnection BaconMessageConnection;

BaconMessageConnection	*bacon_message_connection_new( const char *prefix );
void			bacon_message_connection_free( BaconMessageConnection *conn );
void			bacon_message_connection_set_callback( BaconMessageConnection *conn, BaconMessageReceivedFunc func, gpointer user_data );
void			bacon_message_connection_send( BaconMessageConnection *conn, GList *p_GListFile );
gboolean		bacon_message_connection_get_is_server( BaconMessageConnection *conn );
guint			bacon_utils_get_current_workspace( void );


#endif

