/*  
	Copyright (C) 2006 Salvatore Scarciglia <laas.mono@gmail.com>
	http://laas.altervista.org

    This code is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This code is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

using System;
using Gtk;
using Gdk;
using Glade;

public class yTLargeTranslator {
	[Widget] Gtk.Window		largeTRanslatorWindow;
	[Widget] Gtk.Window		parentWindow;
	[Widget] Gtk.Button		cmdClose;
	[Widget] Gtk.Button		cmdTranslate;
	[Widget] Gtk.Button		cmdCopy;
	[Widget] Gtk.Button		cmdPaste;
	[Widget] Gtk.Label 		lblFrom;
	[Widget] Gtk.Label 		lblTo;
	[Widget] Gtk.TextView	txtTextSource;
	[Widget] Gtk.TextView	txtTextTarget;
	[Widget] Gtk.Image		imgFrom;
	[Widget] Gtk.Image		imgTo;
	private yTUserProfile	currentProfile;
	private yTProvider		currentProvider;
	private yTService		currentService;
	private string 			from;
	
	public yTLargeTranslator(Gtk.Window owner,yTUserProfile usp, yTService cs,yTProvider cp,string fr){
		Glade.XML gxml = new Glade.XML (null, "yt.glade", "largeTRanslatorWindow", null);
		gxml.Autoconnect (this);
		from = fr;
		parentWindow = owner;
		currentProfile = usp;
		currentService = cs;
		currentProvider = cp;
		setupGui();
	}	
	
	
	private void setupGui(){
		largeTRanslatorWindow.Icon = new Gdk.Pixbuf(null,"yTicon.png");
		largeTRanslatorWindow.TransientFor = parentWindow;
		largeTRanslatorWindow.SetPosition(Gtk.WindowPosition.CenterOnParent);
		largeTRanslatorWindow.Modal = true;
		largeTRanslatorWindow.SetSizeRequest(450,350);
		cmdClose.Clicked+=buttonHandler;
		cmdTranslate.Clicked+=buttonHandler;
		cmdCopy.Clicked+=buttonHandler;
		cmdPaste.Clicked+=buttonHandler;
		
		if(from=="1") {
			lblFrom.Text = "Source: <b>" +  currentService.Language1 + "</b>";
			lblFrom.UseMarkup = true;
			lblTo.Text = "Target : <b>" +  currentService.Language2+ "</b>";
			lblTo.UseMarkup = true; 
			imgFrom.Pixbuf = new Pixbuf(null, currentService.Language1+".png");
			imgTo.Pixbuf = new Pixbuf(null, currentService.Language2+".png");				
		}
		else {
			lblFrom.Text = "Source: <b>" +  currentService.Language2 + "</b>";
			lblFrom.UseMarkup = true;
			lblTo.Text = "Target : <b>" +  currentService.Language1+ "</b>";
			lblTo.UseMarkup = true; 
			imgFrom.Pixbuf = new Pixbuf(null, currentService.Language2+".png");
			imgTo.Pixbuf = new Pixbuf(null, currentService.Language1+".png");				
		}
	
		largeTRanslatorWindow.ShowAll();
	}	

	private void  buttonHandler(object o, EventArgs args){
		Button b = (Button) o;
		Clipboard X;
		int fromLang;
		if(from=="1") fromLang=1; else fromLang=2;
		if(b==cmdClose) {
			largeTRanslatorWindow.Destroy();
		}
		else if(b==cmdTranslate) {
			currentService.txtLarge = txtTextTarget;
			currentService.goTranslate(txtTextSource.Buffer.Text, fromLang, true);
		} 
		else if(b==cmdCopy) {
			X = Gtk.Clipboard.Get(Gdk.Atom.Intern("PRIMARY",false));
			if(X.WaitIsTextAvailable())
				X.SetText(txtTextSource.Buffer.Text);
		} 
		else if(b==cmdPaste) {
			X = Gtk.Clipboard.Get(Gdk.Atom.Intern("PRIMARY",false));
			if(X.WaitIsTextAvailable())
				txtTextSource.Buffer.SetText(X.WaitForText());
		} 
	}	
	
	
}